/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.BufferHolder;
import com.maxmind.db.CachedConstructor;
import com.maxmind.db.ClosedDatabaseException;
import com.maxmind.db.DatabaseRecord;
import com.maxmind.db.Decoder;
import com.maxmind.db.DeserializationException;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.InvalidNetworkException;
import com.maxmind.db.Metadata;
import com.maxmind.db.Network;
import com.maxmind.db.Networks;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class Reader
implements Closeable {
    private static final int IPV4_LEN = 4;
    private static final int DATA_SECTION_SEPARATOR_SIZE = 16;
    private static final byte[] METADATA_START_MARKER = new byte[]{-85, -51, -17, 77, 97, 120, 77, 105, 110, 100, 46, 99, 111, 109};
    private final int ipV4Start;
    private final Metadata metadata;
    private final AtomicReference<BufferHolder> bufferHolderReference;
    private final NodeCache cache;
    private final ConcurrentHashMap<Class, CachedConstructor> constructors;

    public Reader(File database) throws IOException {
        this(database, (NodeCache)NoCache.getInstance());
    }

    public Reader(File database, NodeCache cache) throws IOException {
        this(database, FileMode.MEMORY_MAPPED, cache);
    }

    public Reader(InputStream source) throws IOException {
        this(source, (NodeCache)NoCache.getInstance());
    }

    public Reader(InputStream source, NodeCache cache) throws IOException {
        this(new BufferHolder(source), "<InputStream>", cache);
    }

    public Reader(File database, FileMode fileMode) throws IOException {
        this(database, fileMode, (NodeCache)NoCache.getInstance());
    }

    public Reader(File database, FileMode fileMode, NodeCache cache) throws IOException {
        this(new BufferHolder(database, fileMode), database.getName(), cache);
    }

    private Reader(BufferHolder bufferHolder, String name, NodeCache cache) throws IOException {
        this.bufferHolderReference = new AtomicReference<BufferHolder>(bufferHolder);
        if (cache == null) {
            throw new NullPointerException("Cache cannot be null");
        }
        this.cache = cache;
        ByteBuffer buffer = bufferHolder.get();
        int start = this.findMetadataStart(buffer, name);
        Decoder metadataDecoder = new Decoder(this.cache, buffer, start);
        this.metadata = metadataDecoder.decode(start, Metadata.class);
        this.ipV4Start = this.findIpV4StartNode(buffer);
        this.constructors = new ConcurrentHashMap();
    }

    public <T> T get(InetAddress ipAddress, Class<T> cls) throws IOException {
        return this.getRecord(ipAddress, cls).getData();
    }

    int getIpv4Start() {
        return this.ipV4Start;
    }

    public <T> DatabaseRecord<T> getRecord(InetAddress ipAddress, Class<T> cls) throws IOException {
        byte[] rawAddress = ipAddress.getAddress();
        int[] traverseResult = this.traverseTree(rawAddress, rawAddress.length * 8);
        int pl = traverseResult[1];
        int record = traverseResult[0];
        int nodeCount = this.metadata.getNodeCount();
        ByteBuffer buffer = this.getBufferHolder().get();
        Object dataRecord = null;
        if (record > nodeCount) {
            try {
                dataRecord = this.resolveDataPointer(buffer, record, cls);
            }
            catch (DeserializationException exception) {
                throw new DeserializationException("Error getting record for IP " + ipAddress + " -  " + exception.getMessage(), exception);
            }
        }
        return new DatabaseRecord<Object>(dataRecord, ipAddress, pl);
    }

    public <T> Networks<T> networks(Class<T> typeParameterClass) throws InvalidNetworkException, ClosedDatabaseException, InvalidDatabaseException {
        return this.networks(false, typeParameterClass);
    }

    public <T> Networks<T> networks(boolean includeAliasedNetworks, Class<T> typeParameterClass) throws InvalidNetworkException, ClosedDatabaseException, InvalidDatabaseException {
        try {
            if (this.getMetadata().getIpVersion() == 6) {
                InetAddress ipv6 = InetAddress.getByAddress(new byte[16]);
                Network ipAllV6 = new Network(ipv6, 0);
                return this.networksWithin(ipAllV6, includeAliasedNetworks, typeParameterClass);
            }
            InetAddress ipv4 = InetAddress.getByAddress(new byte[4]);
            Network ipAllV4 = new Network(ipv4, 0);
            return this.networksWithin(ipAllV4, includeAliasedNetworks, typeParameterClass);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    BufferHolder getBufferHolder() throws ClosedDatabaseException {
        BufferHolder bufferHolder = this.bufferHolderReference.get();
        if (bufferHolder == null) {
            throw new ClosedDatabaseException();
        }
        return bufferHolder;
    }

    private int startNode(int bitLength) {
        if (this.metadata.getIpVersion() == 6 && bitLength == 32) {
            return this.ipV4Start;
        }
        return 0;
    }

    private int findIpV4StartNode(ByteBuffer buffer) throws InvalidDatabaseException {
        if (this.metadata.getIpVersion() == 4) {
            return 0;
        }
        int node = 0;
        for (int i = 0; i < 96 && node < this.metadata.getNodeCount(); ++i) {
            node = this.readNode(buffer, node, 0);
        }
        return node;
    }

    public <T> Networks<T> networksWithin(Network network, boolean includeAliasedNetworks, Class<T> typeParameterClass) throws InvalidNetworkException, ClosedDatabaseException, InvalidDatabaseException {
        InetAddress networkAddress = network.getNetworkAddress();
        if (this.metadata.getIpVersion() == 4 && networkAddress instanceof Inet6Address) {
            throw new InvalidNetworkException(networkAddress);
        }
        byte[] ipBytes = networkAddress.getAddress();
        int prefixLength = network.getPrefixLength();
        if (this.metadata.getIpVersion() == 6 && ipBytes.length == 4) {
            ipBytes = includeAliasedNetworks ? new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, ipBytes[0], ipBytes[1], ipBytes[2], ipBytes[3]} : new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ipBytes[0], ipBytes[1], ipBytes[2], ipBytes[3]};
            prefixLength += 96;
        }
        int[] traverseResult = this.traverseTree(ipBytes, prefixLength);
        int node = traverseResult[0];
        int prefix = traverseResult[1];
        return new Networks<T>(this, includeAliasedNetworks, new Networks.NetworkNode[]{new Networks.NetworkNode(ipBytes, prefix, node)}, typeParameterClass);
    }

    private int[] traverseTree(byte[] ip, int bitCount) throws ClosedDatabaseException, InvalidDatabaseException {
        int i;
        ByteBuffer buffer = this.getBufferHolder().get();
        int bitLength = ip.length * 8;
        int record = this.startNode(bitLength);
        int nodeCount = this.metadata.getNodeCount();
        for (i = 0; i < bitCount && record < nodeCount; ++i) {
            int b = 0xFF & ip[i / 8];
            int bit = 1 & b >> 7 - i % 8;
            record = this.readNode(buffer, record, bit);
        }
        return new int[]{record, i};
    }

    int readNode(ByteBuffer buffer, int nodeNumber, int index) throws InvalidDatabaseException {
        int baseOffset = nodeNumber * this.metadata.getNodeByteSize();
        switch (this.metadata.getRecordSize()) {
            case 24: {
                buffer.position(baseOffset + index * 3);
                return Decoder.decodeInteger(buffer, 0, 3);
            }
            case 28: {
                int middle = buffer.get(baseOffset + 3);
                middle = index == 0 ? (0xF0 & middle) >>> 4 : 0xF & middle;
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, middle, 3);
            }
            case 32: {
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, 0, 4);
            }
        }
        throw new InvalidDatabaseException("Unknown record size: " + this.metadata.getRecordSize());
    }

    <T> T resolveDataPointer(ByteBuffer buffer, int pointer, Class<T> cls) throws IOException {
        int resolved = pointer - this.metadata.getNodeCount() + this.metadata.getSearchTreeSize();
        if (resolved >= buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's search tree is corrupt: contains pointer larger than the database.");
        }
        Decoder decoder = new Decoder(this.cache, buffer, this.metadata.getSearchTreeSize() + 16, this.constructors);
        return decoder.decode(resolved, cls);
    }

    private int findMetadataStart(ByteBuffer buffer, String databaseName) throws InvalidDatabaseException {
        int fileSize = buffer.capacity();
        block0: for (int i = 0; i < fileSize - METADATA_START_MARKER.length + 1; ++i) {
            for (int j = 0; j < METADATA_START_MARKER.length; ++j) {
                byte b = buffer.get(fileSize - i - j - 1);
                if (b != METADATA_START_MARKER[METADATA_START_MARKER.length - j - 1]) continue block0;
            }
            return fileSize - i;
        }
        throw new InvalidDatabaseException("Could not find a MaxMind DB metadata marker in this file (" + databaseName + "). Is this a valid MaxMind DB file?");
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() throws IOException {
        this.bufferHolderReference.set(null);
    }

    public static enum FileMode {
        MEMORY_MAPPED,
        MEMORY;

    }
}

