/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.transport;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.secure_sm.AccessController;
import org.opensearch.security.ssl.transport.PrincipalExtractor;

public class SPIFFEPrincipalExtractor
implements PrincipalExtractor {
    protected final Logger log = LogManager.getLogger(this.getClass());

    @Override
    public String extractPrincipal(X509Certificate x509Certificate, PrincipalExtractor.Type type) {
        if (x509Certificate == null) {
            return null;
        }
        Collection altNames = (Collection)AccessController.doPrivileged(() -> {
            try {
                return x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException e) {
                this.log.error("Unable to parse X509 altNames", (Throwable)e);
                return null;
            }
        });
        if (altNames == null) {
            return null;
        }
        for (List sanItem : altNames) {
            String uriValue;
            if (sanItem == null || sanItem.size() < 2) continue;
            Integer altNameType = (Integer)sanItem.get(0);
            Object altNameValue = sanItem.get(1);
            if (altNameType == null || altNameType != 6 || !(altNameValue instanceof String) || !(uriValue = (String)altNameValue).startsWith("spiffe://")) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("principal: CN={}", (Object)uriValue);
            }
            return String.format("CN=%s", uriValue);
        }
        return null;
    }
}

