/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import schemacrawler.ermodel.associations.ImplicitAssociationsUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

final class IdMatcher
implements Predicate<ColumnReference> {
    private static final Logger LOGGER = Logger.getLogger(IdMatcher.class.getName());

    IdMatcher() {
    }

    @Override
    public boolean test(ColumnReference proposedAssociation) {
        boolean matches;
        if (proposedAssociation == null) {
            return false;
        }
        Column fkColumn = proposedAssociation.getForeignKeyColumn();
        Column pkColumn = proposedAssociation.getPrimaryKeyColumn();
        String pkColumnName = ImplicitAssociationsUtility.normalizeColumnName(pkColumn);
        String fkColumnName = ImplicitAssociationsUtility.normalizeColumnName(fkColumn);
        String fkBaseName = ImplicitAssociationsUtility.removeId(fkColumn);
        String pkBaseName = ImplicitAssociationsUtility.removeId(pkColumn);
        boolean fkIsPartOfPk = fkColumn.isPartOfPrimaryKey();
        Matcher pkMatcher1 = ImplicitAssociationsUtility.ID_PATTERN.matcher(pkColumnName);
        boolean pkColNameHasId = pkMatcher1.find();
        boolean pkColNameIsJustId = pkColNameHasId && pkMatcher1.start() == 0;
        boolean isPossiblySubentity = pkColNameHasId && fkColumnName.equalsIgnoreCase(pkColumnName) && fkIsPartOfPk;
        boolean bl = matches = pkColNameHasId && (fkBaseName.equals(pkBaseName) || pkColNameIsJustId) && !isPossiblySubentity;
        if (matches && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Implicit association rule matched: IdMatcher for proposed association {0}", proposedAssociation);
        }
        return matches;
    }
}

