/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;

final class TableConstraintColumnWrapper {
    public static TableConstraintColumn createConstrainedColumn(Column fkColumn, TableConstraint tableConstraint) {
        TableConstraintColumn tableConstraintColumn = (TableConstraintColumn)Proxy.newProxyInstance(TableConstraintColumn.class.getClassLoader(), new Class[]{TableConstraintColumn.class}, (InvocationHandler)new TableConstraintColumnHandler(fkColumn, tableConstraint));
        return tableConstraintColumn;
    }

    private TableConstraintColumnWrapper() {
    }

    static final class TableConstraintColumnHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = -5987628834605976612L;
        private final Column fkColumn;
        private final TableConstraint tableConstraint;

        private TableConstraintColumnHandler(Column fkColumn, TableConstraint tableConstraint) {
            this.fkColumn = Objects.requireNonNull(fkColumn, "No foreign key provided");
            this.tableConstraint = Objects.requireNonNull(tableConstraint, "No table constraint provided");
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return switch (method.getName()) {
                    case "getTableConstraint" -> this.tableConstraint;
                    case "getTableConstraintOrdinalPosition" -> 1;
                    default -> method.invoke((Object)this.fkColumn, args);
                };
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    Exception exception = (Exception)cause;
                    throw exception;
                }
                throw new ExecutionRuntimeException("Could not invoke " + String.valueOf(method), e);
            }
        }
    }
}

