/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.utility;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.utility.SerializedObjectInputStream;

public final class SerializedERModelUtility {
    private static final List<Pattern> ERMODEL_CLASS_PATTERNS = Arrays.asList(Pattern.compile("us\\.fatehi\\.utility\\.property\\.[A-Z].*"), Pattern.compile("us\\.fatehi\\.utility\\.database\\.[A-Z].*"), Pattern.compile("us\\.fatehi\\.utility\\.Multimap"), Pattern.compile("schemacrawler\\.(schema(crawler)?|crawl)\\.[A-Z].*"), Pattern.compile("schemacrawler\\.ermodel\\.model\\.[A-Z].*"), Pattern.compile("schemacrawler\\.ermodel\\.implementation\\.[A-Z].*"), Pattern.compile("schemacrawler\\.ermodel\\.associations\\.[A-Z].*"), Pattern.compile("schemacrawler\\.[A-Z].*"), Pattern.compile("(\\[L)?java\\.(lang|util)\\..*"), Pattern.compile("java\\.(sql|math|time|net)\\..*"), Pattern.compile("\\[[BC]"));

    public static ERModel readERModel(InputStream in) {
        Objects.requireNonNull(in, "No input stream provided");
        return (ERModel)SerializedObjectInputStream.read(in, ERMODEL_CLASS_PATTERNS);
    }

    public static void saveERModel(ERModel erModel, OutputStream out) {
        Objects.requireNonNull(erModel, "No ER model provided");
        Objects.requireNonNull(out, "No output stream provided");
        SerializedObjectInputStream.save(erModel, out);
    }

    private SerializedERModelUtility() {
    }
}

