/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.ermodel.utility.EntityModelUtility;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.executable.Command;
import us.fatehi.utility.property.PropertyName;

public abstract class BaseCommand<C, R>
implements Command<C, R> {
    protected final PropertyName command;
    protected C commandOptions;
    protected Catalog catalog;
    protected ERModel erModel;
    protected Connection connection;

    protected BaseCommand(PropertyName command) {
        this.command = Objects.requireNonNull(command, "No command specified");
    }

    @Override
    public void configure(C commandOptions) {
        this.commandOptions = Objects.requireNonNull(commandOptions, "No command options provided");
    }

    @Override
    public final Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public final PropertyName getCommandName() {
        return this.command;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public ERModel getERModel() {
        return this.erModel;
    }

    @Override
    public void initialize() {
        if (this.erModel == null) {
            this.erModel = EntityModelUtility.buildEmptyERModel();
        }
    }

    @Override
    public final void setCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    @Override
    public final void setConnection(Connection connection) {
        if (!this.usesConnection()) {
            throw new ExecutionRuntimeException("<%s> does not use a connection".formatted(this.command.getName()));
        }
        this.connection = connection;
    }

    @Override
    public void setERModel(ERModel erModel) {
        this.erModel = Objects.requireNonNull(erModel, "No ER model provided");
    }

    public String toString() {
        return this.command.toString();
    }
}

