/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateCached(value=false)
abstract class ToPrimitiveBaseNode
extends JavaScriptBaseNode {
    ToPrimitiveBaseNode() {
    }

    @Specialization
    protected static int doInt(int value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static SafeInteger doSafeInteger(SafeInteger value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static long doLong(long value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static double doDouble(double value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static boolean doBoolean(boolean value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static TruffleString doString(TruffleString value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static Symbol doSymbol(Symbol value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization
    protected static BigInt doBigInt(BigInt value, JSToPrimitiveNode.Hint hint) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static JSDynamicObject doNull(Object value, JSToPrimitiveNode.Hint hint) {
        return Null.instance;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static JSDynamicObject doUndefined(Object value, JSToPrimitiveNode.Hint hint) {
        return Undefined.instance;
    }

    @Fallback
    protected Object doFallback(Object value, JSToPrimitiveNode.Hint hint, @Bind Node node) {
        assert (value != null);
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(node);
    }
}

