/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.logging.Logger;

final class Chain<T> {
    private final Link<T>[] vacant;
    private int highWaterMark;
    private Link<T> head = null;
    private Link<T> tail = null;
    private int size = 0;
    private final IntConsumer sizeChangeTrigger;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    Chain(Link<T>[] vacant, int highWaterMark, IntConsumer sizeChangeTrigger) {
        this.vacant = vacant;
        this.highWaterMark = highWaterMark;
        this.sizeChangeTrigger = sizeChangeTrigger;
    }

    Chain(Link<T>[] vacant, int highWaterMark) {
        this(vacant, highWaterMark, p2 -> {});
    }

    static <T> void addHead(T value, Chain<T> ... chains) {
        Link<T> link;
        if (chains.length == 0) {
            link = null;
        } else {
            Link<T>[] vacant = chains[0].vacant;
            int highWaterMark = chains[0].highWaterMark;
            highWaterMark = Math.max(0, highWaterMark - 1);
            link = vacant[highWaterMark];
            vacant[highWaterMark] = null;
        }
        if (link == null) {
            new Link<T>(value, chains);
        } else {
            link.link(value, chains);
        }
    }

    T removeHead() {
        return this.remove(this.head);
    }

    T removeTail() {
        return this.remove(this.tail);
    }

    private T remove(Link<T> chainEdge) {
        if (chainEdge == null) {
            return null;
        }
        this.highWaterMark = Math.min(this.highWaterMark + 1, this.vacant.length - 1);
        this.vacant[this.highWaterMark] = chainEdge;
        return chainEdge.unlink();
    }

    int size() {
        return this.size;
    }

    void forEach(Consumer<? super T> action) {
        Integer index = null;
        Link<T> link = this.head;
        while (null != link) {
            action.accept(link.value);
            if (index == null) {
                for (int i2 = 0; i2 < link.chains.length; ++i2) {
                    if (this != link.chains[i2]) continue;
                    index = i2;
                    break;
                }
            }
            link = link.next[index];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("[ ");
        boolean[] comma = new boolean[]{false};
        this.forEach(p2 -> {
            sb.append(comma[0] ? ", " : "").append(p2.toString());
            comma[0] = true;
        });
        return sb.append(" ]").toString();
    }

    static {
        try {
            $$$methodRef$$$10 = Chain.class.getDeclaredConstructor(Link[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Chain.class.getDeclaredConstructor(Link[].class, Integer.TYPE, IntConsumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Chain.class.getDeclaredMethod("lambda$new$0", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Chain.class.getDeclaredMethod("lambda$toString$1", StringBuilder.class, boolean[].class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Chain.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Chain.class.getDeclaredMethod("forEach", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Chain.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Chain.class.getDeclaredMethod("remove", Link.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Chain.class.getDeclaredMethod("removeTail", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Chain.class.getDeclaredMethod("removeHead", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Chain.class.getDeclaredMethod("addHead", Object.class, Chain[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class Link<T> {
        private T value;
        private Chain<T>[] chains;
        private final Link<T>[] prev;
        private final Link<T>[] next;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private Link(T value, Chain<T> ... chains) {
            this.prev = new Link[chains.length];
            this.next = new Link[chains.length];
            this.link(value, chains);
        }

        private void link(T value, Chain<T> ... chains) {
            this.value = value;
            this.chains = chains;
            for (int i2 = 0; i2 < chains.length; ++i2) {
                Chain<T> c2 = chains[i2];
                c2.sizeChangeTrigger.accept(++c2.size);
                this.next[i2] = c2.head;
                this.prev[i2] = null;
                if (null != c2.head) {
                    c2.head.prev[i2] = this;
                }
                c2.head = this;
                if (null != c2.tail) continue;
                c2.tail = this;
            }
        }

        private T unlink() {
            T retVal = this.value;
            this.value = null;
            for (int i2 = 0; i2 < this.chains.length; ++i2) {
                Chain<T> c2 = this.chains[i2];
                c2.sizeChangeTrigger.accept(--c2.size);
                if (this.prev[i2] == null) {
                    c2.head = this.next[i2];
                } else {
                    this.prev[i2].next[i2] = this.next[i2];
                }
                if (this.next[i2] == null) {
                    c2.tail = this.prev[i2];
                    continue;
                }
                this.next[i2].prev[i2] = this.prev[i2];
            }
            return retVal;
        }

        public String toString() {
            return this.value.toString();
        }

        static {
            try {
                $$$methodRef$$$3 = Link.class.getDeclaredConstructor(Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Link.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Link.class.getDeclaredMethod("unlink", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Link.class.getDeclaredMethod("link", Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

