/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BufferedPublisher;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

abstract class LobSegmentSubscriber<T>
implements Flow.Subscriber<T> {
    private final Monitor signalMonitor = Monitor.newInstance();
    private final LobSegmentBuffer<T> buffer;
    private final BufferedPublisher<Long> outcomePublisher;
    private final Runnable terminalAction;
    private final Executor userCodeExecutor;
    private Flow.Subscription subscription;
    private boolean isTerminated = false;
    private volatile CompletionStage<Void> pushSegmentStage = CompletableFuture.completedFuture(null);
    static final Flow.Subscriber<Long> NO_OUTCOME_SUBSCRIBER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    LobSegmentSubscriber(LobSegmentBuffer<T> buffer, Flow.Subscriber<Long> outcomeSubscriber, Runnable terminalAction, Executor userCodeExecutor) {
        this.userCodeExecutor = userCodeExecutor;
        this.buffer = buffer;
        if (outcomeSubscriber == NO_OUTCOME_SUBSCRIBER) {
            this.outcomePublisher = null;
        } else {
            this.outcomePublisher = BufferedPublisher.newInstance(Flow.defaultBufferSize(), userCodeExecutor);
            this.outcomePublisher.subscribe(outcomeSubscriber);
        }
        this.terminalAction = terminalAction;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
            if (this.subscription != null) {
                subscription.cancel();
                if (subscription.equals(this.subscription)) {
                    this.cancelSubscription();
                }
                return;
            }
            this.subscription = subscription;
            this.requestNext();
        }
    }

    @Override
    public final void onNext(T nextSegment) {
        Objects.requireNonNull(nextSegment);
        try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.pushSegmentStage = this.pushSegment(nextSegment, 0).thenAccept(nil -> {
                if (!this.isTerminated) {
                    this.requestNext();
                }
            });
        }
    }

    private final CompletionStage<Void> pushSegment(T segment, int offset) {
        int putLength = this.buffer.putSegment(segment, offset);
        int putRemaining = this.buffer.getSegmentLength(segment) - (offset + putLength);
        if (putRemaining == 0) {
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        T segmentClone = this.clone(segment);
        return this.flushBufferAsync(true).thenCompose(nil -> this.pushSegment(segmentClone, offset + putLength));
    }

    private final void requestNext() {
        this.userCodeExecutor.execute(() -> {
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                this.subscription.request(1L);
            }
        });
    }

    @Override
    public final void onComplete() {
        try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage = this.pushSegmentStage.thenCompose(nil -> {
                if (this.buffer.getPosition() > 0) {
                    return this.flushBufferAsync(false);
                }
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }).whenComplete((nil, err) -> {
                if (err == null && this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(null);
                }
                this.terminalAction.run();
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onError(Throwable throwable) {
        void error;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        Objects.requireNonNull(error);
        if (bl) {
            OracleLog.log($$$loggerRef$$$5, Level.FINEST, LobSegmentSubscriber.class, $$$methodRef$$$5, "LOB Subscriber onError(Throwable) was invoked with:", (Throwable)error);
        }
        try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage.whenComplete((arg_0, arg_1) -> this.lambda$onError$5((Throwable)error, arg_0, arg_1));
        }
    }

    private final void cancelSubscription() {
        try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
            this.userCodeExecutor.execute(() -> {
                try (Monitor.CloseableLock serialLock = this.signalMonitor.acquireCloseableLock();){
                    this.subscription.cancel();
                }
            });
            if (!this.isTerminated) {
                this.isTerminated = true;
                this.terminalAction.run();
            }
        }
    }

    private final CompletionStage<Void> flushBufferAsync(boolean awaitOutcomeBuffer) {
        int writeLength = this.buffer.getPosition();
        CompletionStage<Void> flushBufferStage = this.flushBufferAsync(writeLength).whenComplete((nil, err) -> {
            if (err == null) {
                this.buffer.reset();
            } else {
                this.cancelSubscription();
                if (this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(CompletionStageUtil.unwrapCompletionException(err));
                }
            }
        });
        if (this.outcomePublisher != null) {
            CompletionStage<Void> outcomeBufferStage = flushBufferStage.thenCompose(nil -> this.outcomePublisher.offerItem(Long.valueOf(writeLength)));
            if (awaitOutcomeBuffer) {
                return outcomeBufferStage;
            }
        }
        return flushBufferStage;
    }

    abstract CompletionStage<Void> flushBufferAsync(int var1);

    abstract T clone(T var1);

    private /* synthetic */ void lambda$onError$5(Throwable error, Void nil, Throwable err) {
        this.terminalAction.run();
        if (this.outcomePublisher != null && err == null) {
            this.outcomePublisher.terminate(DatabaseError.createSqlException(null, 1713, null, error).fillInStackTrace());
        }
    }

    static {
        try {
            $$$methodRef$$$17 = LobSegmentSubscriber.class.getDeclaredConstructor(LobSegmentBuffer.class, Flow.Subscriber.class, Runnable.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onNext$0", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$pushSegment$1", Object.class, Integer.TYPE, Integer.TYPE, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$requestNext$2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onComplete$3", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onComplete$4", Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onError$5", Throwable.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$cancelSubscription$6", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$flushBufferAsync$7", Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$flushBufferAsync$8", Integer.TYPE, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LobSegmentSubscriber.class.getDeclaredMethod("flushBufferAsync", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LobSegmentSubscriber.class.getDeclaredMethod("cancelSubscription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LobSegmentSubscriber.class.getDeclaredMethod("onError", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LobSegmentSubscriber.class.getDeclaredMethod("onComplete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LobSegmentSubscriber.class.getDeclaredMethod("requestNext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LobSegmentSubscriber.class.getDeclaredMethod("pushSegment", Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LobSegmentSubscriber.class.getDeclaredMethod("onNext", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LobSegmentSubscriber.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_OUTCOME_SUBSCRIBER = new Flow.Subscriber<Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;

            @Override
            public void onSubscribe(Flow.Subscription outcomeSubscription) {
            }

            @Override
            public void onNext(Long outcome) {
            }

            @Override
            public void onError(Throwable failedOutcome) {
            }

            @Override
            public void onComplete() {
            }

            static {
                try {
                    $$$methodRef$$$5 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = 1.class.getDeclaredMethod("onNext", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("onComplete", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("onError", Throwable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("onNext", Long.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static abstract class LobSegmentBuffer<T> {
        private volatile int position = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        LobSegmentBuffer() {
        }

        static LobSegmentBuffer<byte[]> newByteBuffer(final byte[] buffer) {
            return new LobSegmentBuffer<byte[]>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;

                @Override
                protected int copyToBuffer(byte[] segment, int segmentOffset, int bufferPosition) {
                    int copyLength = Math.min(buffer.length - bufferPosition, segment.length - segmentOffset);
                    System.arraycopy(segment, segmentOffset, buffer, bufferPosition, copyLength);
                    return copyLength;
                }

                @Override
                protected int getSegmentLength(byte[] segment) {
                    return segment.length;
                }

                static {
                    try {
                        $$$methodRef$$$4 = 1.class.getDeclaredConstructor(byte[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredMethod("copyToBuffer", Object.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("getSegmentLength", Object.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("getSegmentLength", byte[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("copyToBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }

        static LobSegmentBuffer<String> newCharacterBuffer(final char[] buffer) {
            return new LobSegmentBuffer<String>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;

                @Override
                protected int copyToBuffer(String segment, int offset, int bufferPosition) {
                    int copyLength = Math.min(buffer.length - bufferPosition, segment.length() - offset);
                    segment.getChars(offset, offset + copyLength, buffer, bufferPosition);
                    return copyLength;
                }

                @Override
                protected int getSegmentLength(String segment) {
                    return segment.length();
                }

                static {
                    try {
                        $$$methodRef$$$4 = 2.class.getDeclaredConstructor(char[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 2.class.getDeclaredMethod("copyToBuffer", Object.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredMethod("getSegmentLength", Object.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("getSegmentLength", String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("copyToBuffer", String.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }

        private int getPosition() {
            return this.position;
        }

        private void reset() {
            this.position = 0;
        }

        private int putSegment(T segment, int offset) {
            int copyLength = this.copyToBuffer(segment, offset, this.position);
            this.position += copyLength;
            return copyLength;
        }

        protected abstract int copyToBuffer(T var1, int var2, int var3);

        protected abstract int getSegmentLength(T var1);

        static {
            try {
                $$$methodRef$$$5 = LobSegmentBuffer.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = LobSegmentBuffer.class.getDeclaredMethod("putSegment", Object.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = LobSegmentBuffer.class.getDeclaredMethod("reset", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = LobSegmentBuffer.class.getDeclaredMethod("getPosition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = LobSegmentBuffer.class.getDeclaredMethod("newCharacterBuffer", char[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = LobSegmentBuffer.class.getDeclaredMethod("newByteBuffer", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

