/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleClobReader
extends Reader {
    OracleClob clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition;
    boolean isClosed;
    boolean endOfStream;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    public OracleClobReader(CLOB clob) throws SQLException {
        this((OracleClob)clob);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleClobReader.class, $$$methodRef$$$11, null, clob);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleClobReader.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleClobReader.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleClobReader.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(OracleClob clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getInternalConnection()).getDefaultStreamChunkSize() / 3);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleClobReader.class, $$$methodRef$$$12, null, clob);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleClobReader.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleClobReader.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleClobReader.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleClobReader.class, $$$methodRef$$$13, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleClobReader.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleClobReader.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleClobReader.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleClobReader.class, $$$methodRef$$$14, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleClobReader.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleClobReader.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleClobReader.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleClobReader.class, $$$methodRef$$$15, null, clob, bufferSize, beginOffset);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleClobReader.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleClobReader.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleClobReader.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleClobReader.class, $$$methodRef$$$16, null, clob, bufferSize, beginOffset);
            }
            this.maxPosition = Long.MAX_VALUE;
            if (clob == null || bufferSize <= 0 || clob.getInternalConnection() == null || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleClobReader.class, $$$methodRef$$$16, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
            this.clob = clob;
            this.lobOffset = beginOffset;
            this.markedChar = -1L;
            this.resizableBuffer = null;
            this.initialBufferSize = bufferSize;
            this.currentBufferSize = 0;
            this.count = 0;
            this.pos = 0;
            this.isClosed = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleClobReader.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleClobReader.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleClobReader.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset, length);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleClobReader.class, $$$methodRef$$$17, null, clob, bufferSize, beginOffset, length);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleClobReader.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleClobReader.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleClobReader.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobReader(OracleClob clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this(clob, bufferSize, beginOffset);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleClobReader.class, $$$methodRef$$$18, null, clob, bufferSize, beginOffset, length);
            }
            this.maxPosition = beginOffset + length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleClobReader.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleClobReader.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleClobReader.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void cbuf;
            void len;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, cArray, n2, n3);
            }
            this.ensureOpen();
            void start = off;
            void end = start + Math.min((int)len, ((void)cbuf).length - off);
            if (!this.needChars((int)(end - start))) {
                int n4 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, null);
                }
                return -1;
            }
            start += this.writeChars((char[])cbuf, (int)start, (int)(end - start));
            while (start < end && this.needChars((int)(end - start))) {
                start += this.writeChars((char[])cbuf, (int)start, (int)(end - start));
            }
            void var7_8 = start - off;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, (int)var7_8);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, null);
            }
            return (int)var7_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobReader.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean needChars(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, n2);
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block22: {
                    if (!this.endOfStream) {
                        boolean bl2;
                        block23: {
                            boolean bl3;
                            try {
                                void howMany;
                                if (howMany > this.currentBufferSize) {
                                    this.currentBufferSize = Math.max((int)howMany, this.initialBufferSize);
                                    PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                    Monitor.CloseableLock lock = pConnection.acquireCloseableLock();
                                    try {
                                        this.resizableBuffer = pConnection.getCharBuffer(this.currentBufferSize);
                                        if (lock != null) {
                                            lock.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (lock != null) {
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        Throwable throwable3 = throwable;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, throwable3);
                                        }
                                        throw throwable3;
                                    }
                                }
                                int size = this.currentBufferSize;
                                if (this.maxPosition - this.lobOffset < (long)this.currentBufferSize) {
                                    size = (int)(this.maxPosition - this.lobOffset);
                                }
                                this.count = this.clob.getChars(this.lobOffset, size, this.resizableBuffer);
                                if (this.count < this.currentBufferSize) {
                                    this.endOfStream = true;
                                }
                                if (this.count <= 0) break block22;
                                this.pos = 0;
                                this.lobOffset += (long)this.count;
                                if (this.lobOffset >= this.maxPosition) {
                                    this.endOfStream = true;
                                }
                                bl2 = bl3 = true;
                                if (!bl) break block23;
                            }
                            catch (SQLException e2) {
                                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, iOException);
                                }
                                throw iOException;
                            }
                            ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, null);
                        }
                        return bl2;
                    }
                }
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, null);
                }
                return false;
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobReader.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int writeChars(char[] cArray, int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void destbuf;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleClobReader.class, $$$methodRef$$$2, this, cArray, n2, n3);
            }
            int availableLength = Math.min((int)length, this.count - this.pos);
            System.arraycopy(this.resizableBuffer, this.pos, destbuf, (int)offset, availableLength);
            this.pos += availableLength;
            int n4 = availableLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleClobReader.class, $$$methodRef$$$2, this, n4);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobReader.class, $$$methodRef$$$2, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobReader.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean ready() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleClobReader.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.ensureOpen();
            boolean bl3 = bl2 = this.pos < this.count;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleClobReader.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobReader.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobReader.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (this.isClosed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, null);
                }
                return;
            }
            try {
                this.isClosed = true;
                PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                Monitor.CloseableLock lock = pConnection.acquireCloseableLock();
                try {
                    if (this.resizableBuffer != null) {
                        pConnection.cacheBuffer(this.resizableBuffer);
                        this.resizableBuffer = null;
                    }
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobReader.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this, new Object[0]);
            }
            try {
                if (this.isClosed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobReader.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleClobReader.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleClobReader.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobReader.class, $$$methodRef$$$6, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobReader.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void readAheadLimit;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleClobReader.class, $$$methodRef$$$7, this, n2);
            }
            if (readAheadLimit < 0) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(DatabaseError.findMessage(195, null));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleClobReader.class, $$$methodRef$$$7, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleClobReader.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobReader.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobReader.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleClobReader.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.markedChar < 0L) {
                IOException iOException = new IOException(DatabaseError.findMessage(195, null));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleClobReader.class, $$$methodRef$$$8, this, iOException);
                }
                throw iOException;
            }
            this.lobOffset = this.markedChar;
            this.pos = this.count;
            this.endOfStream = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobReader.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobReader.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobReader.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long l2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleClobReader.class, $$$methodRef$$$9, this, l2);
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = this.clob.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleClobReader.class, $$$methodRef$$$9, this, iOException);
                    }
                    throw iOException;
                }
            }
            long l3 = start;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleClobReader.class, $$$methodRef$$$9, this, l3);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobReader.class, $$$methodRef$$$9, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobReader.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, new Object[0]);
                }
                try {
                    oracleConnection = this.clob.getInternalConnection();
                    if (!bl) break block7;
                }
                catch (Exception exc) {
                    OracleConnection oracleConnection2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, oracleConnection2);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobReader.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$18 = OracleClobReader.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleClobReader.class.getDeclaredConstructor(CLOB.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleClobReader.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleClobReader.class.getDeclaredConstructor(CLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleClobReader.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleClobReader.class.getDeclaredConstructor(CLOB.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleClobReader.class.getDeclaredConstructor(OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleClobReader.class.getDeclaredConstructor(CLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleClobReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleClobReader.class.getDeclaredMethod("skip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleClobReader.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleClobReader.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleClobReader.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleClobReader.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleClobReader.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleClobReader.class.getDeclaredMethod("ready", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleClobReader.class.getDeclaredMethod("writeChars", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleClobReader.class.getDeclaredMethod("needChars", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleClobReader.class.getDeclaredMethod("read", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

