/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Log;

@DisableTrace
public class OracleLog {
    private static Vector registeredClassLOG = new Vector();
    private static final String DEFAULT_LOGGING_CONFIG_RESOURCE_NAME = "/oracle/jdbc/defaultLoggingConfig.properties";
    private static boolean isContinuousLoggingEnabled = false;
    private static boolean isInMemoryLoggingEnabled = true;
    private static String userNameFilter = null;
    private static String serviceNameFilter = null;
    private static final int maxPrintBytes = 512;
    public static boolean TRACE = false;
    private static ThreadLocal<Boolean> recursiveTrace = new ThreadLocal<Boolean>(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        protected Boolean initialValue() {
            return false;
        }

        static {
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    };
    private static ThreadLocal<Integer> callDepth = new ThreadLocal<Integer>(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        protected Integer initialValue() {
            return 0;
        }

        static {
            try {
                $$$methodRef$$$2 = 2.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = 2.class.getDeclaredMethod("initialValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = 2.class.getDeclaredMethod("initialValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    };
    public static final Level INTERNAL_ERROR = OracleLevel.INTERNAL_ERROR;
    public static final Level TRACE_1 = OracleLevel.TRACE_1;
    public static final Level TRACE_10 = OracleLevel.TRACE_10;
    public static final Level TRACE_16 = OracleLevel.TRACE_16;
    public static final Level TRACE_20 = OracleLevel.TRACE_20;
    public static final Level TRACE_30 = OracleLevel.TRACE_30;
    public static final Level TRACE_32 = OracleLevel.TRACE_32;
    static boolean securityExceptionWhileGettingSystemProperties;

    @Log
    public static void debug(Logger logger, Level level, Class<?> cls, Executable method, String msg) {
        ClioSupport.log(logger, level, cls, method, msg);
    }

    @Log
    public static void warning(Logger logger, Class<?> cls, Executable method, String msg) {
        ClioSupport.log(logger, Level.WARNING, cls, method, msg);
    }

    @Log
    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg) {
        ClioSupport.log(logger, level, cls, method, msg);
    }

    @Log
    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg, Throwable e2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e2.printStackTrace(pw);
        OracleLog.debug(logger, level, cls, method, msg + "\n" + sw.toString());
    }

    @Log
    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg, Object[] params) {
        ClioSupport.log(logger, level, cls, method, msg, params);
    }

    @Log
    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg, Object params) {
        ClioSupport.log(logger, level, cls, method, msg, new Object[]{params});
    }

    public static void enableContinousLogging() {
        isContinuousLoggingEnabled = true;
    }

    public static void disableContinousLogging() {
        isContinuousLoggingEnabled = false;
    }

    public static boolean isContinousLoggingEnabled() {
        return isContinuousLoggingEnabled;
    }

    public static void enableInMemoryLogging() {
        isInMemoryLoggingEnabled = true;
    }

    public static void disableInMemoryLogging() {
        isInMemoryLoggingEnabled = false;
    }

    public static boolean isInMemoryLoggingEnabled() {
        return isInMemoryLoggingEnabled;
    }

    public static void setUserNameFilter(String userName) {
        userNameFilter = userName;
    }

    public static void setServiceNameFilter(String serviceName) {
        serviceNameFilter = serviceName;
    }

    public static boolean isDebugZip() {
        boolean ret_val = true;
        return ret_val;
    }

    public static boolean isPrivateLogAvailable() {
        boolean ret_val = false;
        return ret_val;
    }

    public static boolean isEnabled() {
        return TRACE;
    }

    public static boolean registerClassNameAndGetCurrentTraceSetting(Class<?> classObj) {
        if (!registeredClassLOG.contains(classObj)) {
            registeredClassLOG.addElement(classObj);
        }
        return TRACE;
    }

    public static void setTrace(boolean enable) {
        Enumeration regClasses = registeredClassLOG.elements();
        while (regClasses.hasMoreElements()) {
            Class classObj = (Class)regClasses.nextElement();
            try {
                classObj.getField("TRACE").setBoolean(null, enable);
            }
            catch (Exception exception) {}
        }
        TRACE = enable;
    }

    private static void initialize() {
        OracleLog.setupFromSystemProperties();
        if (!TRACE) {
            OracleLog.enableDefaultTrace();
        }
    }

    public static void setupFromSystemProperties() {
        boolean turnLoggingOn = false;
        securityExceptionWhileGettingSystemProperties = false;
        try {
            String propStr = null;
            propStr = GeneratedPhysicalConnection.getSystemPropertyTrace();
            if ("true".equals(propStr)) {
                turnLoggingOn = true;
            }
        }
        catch (SecurityException e2) {
            securityExceptionWhileGettingSystemProperties = true;
        }
        OracleLog.setTrace(turnLoggingOn);
    }

    public static void enableDefaultTrace() {
        try {
            InputStream in = PhysicalConnection.class.getResourceAsStream(DEFAULT_LOGGING_CONFIG_RESOURCE_NAME);
            if (in != null) {
                LogManager.getLogManager().readConfiguration(in);
                OracleLog.setTrace(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String argument() {
        return "";
    }

    public static String argument(boolean x2) {
        return Boolean.toString(x2);
    }

    public static String argument(byte x2) {
        return Byte.toString(x2);
    }

    public static String argument(short x2) {
        return Short.toString(x2);
    }

    public static String argument(int x2) {
        return Integer.toString(x2);
    }

    public static String argument(long x2) {
        return Long.toString(x2);
    }

    public static String argument(float x2) {
        return Float.toString(x2);
    }

    public static String argument(double x2) {
        return Double.toString(x2);
    }

    public static String argument(Object x2) {
        if (x2 == null) {
            return "null";
        }
        if (x2 instanceof String) {
            return "\"" + (String)x2 + "\"";
        }
        return x2.toString();
    }

    @Deprecated
    public static String byteToHexString(byte b2) {
        StringBuffer buf = new StringBuffer("");
        int b_value = 0xFF & b2;
        if (b_value <= 15) {
            buf.append("0x0");
        } else {
            buf.append("0x");
        }
        buf.append(Integer.toHexString(b_value));
        return buf.toString();
    }

    @Deprecated
    public static String bytesToPrintableForm(String header, byte[] bytes) {
        int bytes_len = bytes == null ? 0 : bytes.length;
        return OracleLog.bytesToPrintableForm(header, bytes, bytes_len);
    }

    @Deprecated
    public static String bytesToPrintableForm(String header, byte[] bytes, int nbytes) {
        String ret_str = null;
        ret_str = bytes == null ? header + ": null" : header + " (" + bytes.length + " bytes):\n" + OracleLog.bytesToFormattedStr(bytes, nbytes, "  ");
        return ret_str;
    }

    @Deprecated
    public static String bytesToFormattedStr(byte[] bytes, int nbytes, String margin) {
        StringBuffer buf = new StringBuffer("");
        if (margin == null) {
            margin = new String("");
        }
        buf.append(margin);
        if (bytes == null) {
            buf.append("byte [] is null");
            return buf.toString();
        }
        for (int i2 = 0; i2 < nbytes; ++i2) {
            int b_value;
            if (i2 >= 512) {
                buf.append("\n" + margin + "... last " + (nbytes - 512) + " bytes were not printed to limit the output size");
                break;
            }
            if (i2 > 0 && i2 % 20 == 0) {
                buf.append("\n" + margin);
            }
            if (i2 % 20 == 10) {
                buf.append(" ");
            }
            if ((b_value = 0xFF & bytes[i2]) <= 15) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(b_value) + " ");
        }
        return buf.toString();
    }

    @Deprecated
    public static byte[] strToUcs2Bytes(String str) {
        if (str == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(str.toCharArray());
    }

    @Deprecated
    public static byte[] charsToUcs2Bytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(chars, chars.length);
    }

    @Deprecated
    public static byte[] charsToUcs2Bytes(char[] chars, int nchars) {
        if (chars == null) {
            return null;
        }
        if (nchars < 0) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(chars, nchars, 0);
    }

    @Deprecated
    public static byte[] charsToUcs2Bytes(char[] chars, int nchars, int offset) {
        if (chars == null) {
            return null;
        }
        if (nchars > chars.length - offset) {
            nchars = chars.length - offset;
        }
        if (nchars < 0) {
            return null;
        }
        byte[] bytes = new byte[2 * nchars];
        int byte_i = 0;
        for (int char_i = offset; char_i < nchars; ++char_i) {
            bytes[byte_i++] = (byte)(chars[char_i] >> 8 & 0xFF);
            bytes[byte_i++] = (byte)(chars[char_i] & 0xFF);
        }
        return bytes;
    }

    @Deprecated
    public static String toPrintableStr(String str, int maxchars) {
        if (str == null) {
            return "null";
        }
        if (str.length() > maxchars) {
            return str.substring(0, maxchars - 1) + "\n ... the actual length was " + str.length();
        }
        return str;
    }

    public static boolean recursiveEnter() {
        if (recursiveTrace.get().booleanValue()) {
            return false;
        }
        recursiveTrace.set(true);
        return true;
    }

    public static void recursiveExit() {
        recursiveTrace.set(false);
    }

    public static boolean isPublic() {
        return callDepth.get() == 1;
    }

    public static boolean enter() {
        int d2 = callDepth.get();
        callDepth.set(d2 + 1);
        return d2 == 0;
    }

    public static boolean exit() {
        int d2 = callDepth.get() - 1;
        callDepth.set(d2);
        return d2 == 0;
    }

    public static String toHex(long value, int bytes) {
        String result;
        switch (bytes) {
            case 1: {
                result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return OracleLog.toHex(value >> 32, 4) + OracleLog.toHex(value, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + result.substring(result.length() - 2 * bytes);
    }

    public static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    public static String toHex(short value) {
        return OracleLog.toHex(value, 2);
    }

    public static String toHex(int value) {
        return OracleLog.toHex(value, 4);
    }

    public static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        Object result = "[";
        int len = Math.min(64, length);
        for (int i2 = 0; i2 < len; ++i2) {
            result = (String)result + OracleLog.toHex(value[i2]) + " ";
        }
        if (len < length) {
            result = (String)result + "...";
        }
        return (String)result + "]";
    }

    public static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return OracleLog.toHex(value, value.length);
    }

    static {
        OracleLog.initialize();
    }

    private static class OracleLevel
    extends Level {
        private static final long serialVersionUID = -2613875615050961941L;
        static final OracleLevel INTERNAL_ERROR;
        static final OracleLevel TRACE_1;
        static final OracleLevel TRACE_10;
        static final OracleLevel TRACE_16;
        static final OracleLevel TRACE_20;
        static final OracleLevel TRACE_30;
        static final OracleLevel TRACE_32;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        OracleLevel(String name, int n2) {
            super(name, n2);
        }

        static {
            try {
                $$$methodRef$$$0 = OracleLevel.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            INTERNAL_ERROR = new OracleLevel("INTERNAL_ERROR", 1100);
            TRACE_1 = new OracleLevel("TRACE_1", Level.FINE.intValue());
            TRACE_10 = new OracleLevel("TRACE_10", 446);
            TRACE_16 = new OracleLevel("TRACE_16", Level.FINER.intValue());
            TRACE_20 = new OracleLevel("TRACE_20", 376);
            TRACE_30 = new OracleLevel("TRACE_30", 316);
            TRACE_32 = new OracleLevel("TRACE_32", Level.FINEST.intValue());
        }
    }
}

