/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleParameterMetaDataParserStates;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class OracleParameterMetaDataParser {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST;
    String parameterSql;
    OracleStatement.SqlKind sqlKind;
    int parameterCount;
    boolean needToParseSql;
    private static final int cMax = 127;
    private static final int[][] TRANSITION;
    private static final int[][] ACTION;
    private static final int NO_ACTION = 0;
    private static final int WHERE_ACTION = 2;
    private static final int PARAMETER_ACTION = 3;
    private static final int END_PARAMETER_ACTION = 4;
    private static final int COUNT_BIND_ACTION = 5;
    private static final int START_NCHAR_LITERAL_ACTION = 6;
    private static final int END_NCHAR_LITERAL_ACTION = 7;
    private static final int SAVE_DELIMITER_ACTION = 8;
    private static final int LOOK_FOR_DELIMITER_ACTION = 9;
    private static final int RECORD_TABLE_NAME_ACTION = 10;
    private static final int END_RECORD_TABLE_NAME_ACTION = 11;
    private static final int DONE_RECORD_TABLE_NAME_ACTION = 12;
    private static final int START_RECORD_COLUMN_NAME_ACTION = 13;
    private static final int RECORD_COLUMN_NAME_ACTION = 14;
    private static final int END_RECORD_COLUMN_NAME_ACTION = 15;
    private static final int DONE_RECORD_COLUMN_NAME_ACTION = 16;
    private static final int NO_PARAMETER_METADATA_ACTION = 17;
    private static final int BEGIN_COMMENT_ACTION = 18;
    private static final int END_COMMENT_ACTION = 19;
    private static final int RESET_RECORDING_ACTION = 20;
    private static final int START_JSON_ACTION = 21;
    private static final int END_JSON_ACTION = 22;
    private static final int INITIAL_STATE = 0;
    private static final int RESTART_STATE = 22;
    private static final boolean DEBUG_CBI = false;
    ArrayList<String> tableName;
    ArrayList<String> columnName;
    byte[] bindStatusForInsert;
    char[] currentParameter;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    protected OracleParameterMetaDataParser() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$11, null, new Object[0]);
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.parameterCount = -1;
            this.tableName = new ArrayList();
            this.columnName = new ArrayList();
            this.bindStatusForInsert = null;
            this.currentParameter = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(String string, OracleStatement.SqlKind sqlKind, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _paramCount;
            void kind;
            void _pSql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$0, this, new Object[]{string, sqlKind, n2});
            }
            if (_pSql == null || _pSql.length() == 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            this.sqlKind = kind;
            this.parameterSql = _pSql;
            this.parameterCount = _paramCount;
            this.needToParseSql = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void computeBasicInfo(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$1, this, string);
            }
            int bindPositionIndex = 0;
            boolean delimiter = false;
            int currentParameterLength = 0;
            int s2 = 0;
            int len = sql.length();
            int stop = len + 1;
            char[] temp = new char[512];
            int tableIndex = 0;
            int columnIndex = 0;
            this.columnName.clear();
            this.tableName.clear();
            boolean bindFound = false;
            boolean skippedColumns = false;
            boolean columnStatusIndex = false;
            int lastBindPosition = 0;
            int lastBindCountPosition = 0;
            boolean canSupportParameterMetaData = true;
            int savedState = 0;
            ArrayDeque<Character> jsonDelimiter = new ArrayDeque<Character>();
            this.bindStatusForInsert = null;
            block22: for (int i2 = 0; i2 < stop; ++i2) {
                char unicodeChar;
                char c2 = unicodeChar = i2 < len ? (char)sql.charAt(i2) : (char)' ';
                if (unicodeChar > '\u007f') {
                    c2 = Character.isLetterOrDigit(unicodeChar) ? (char)'X' : ' ';
                }
                switch (ACTION[s2][c2]) {
                    case 18: {
                        savedState = s2;
                        s2 = c2 == '/' ? 18 : 20;
                        break;
                    }
                    case 19: {
                        s2 = c2 == '/' ? 19 : 20;
                        savedState = 0;
                        continue block22;
                    }
                    case 20: {
                        columnIndex = 0;
                        tableIndex = 0;
                        savedState = 68;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        if (tableIndex <= 0) break;
                        tableIndex -= 5;
                        break;
                    }
                    case 3: {
                        String s1;
                        if (columnIndex > 0 && (s1 = new String(temp, 0, columnIndex)).trim().length() > 0) {
                            this.columnName.add(s1);
                        }
                        columnIndex = 0;
                        if (currentParameterLength == 0) {
                            lastBindPosition = i2;
                        }
                        ++currentParameterLength;
                        bindFound = true;
                        break;
                    }
                    case 5: {
                        if (bindFound) {
                            if (this.bindStatusForInsert == null) {
                                int size = Math.max(50, bindPositionIndex >> 1);
                                this.bindStatusForInsert = new byte[size];
                            } else if (bindPositionIndex >= this.bindStatusForInsert.length) {
                                byte[] b2 = new byte[this.bindStatusForInsert.length << 1];
                                System.arraycopy(this.bindStatusForInsert, 0, b2, 0, this.bindStatusForInsert.length);
                                this.bindStatusForInsert = b2;
                            }
                            this.bindStatusForInsert[bindPositionIndex] = 1;
                        }
                        lastBindCountPosition = i2;
                        ++bindPositionIndex;
                        bindFound = false;
                    }
                    case 4: {
                        bindFound = false;
                        currentParameterLength = 0;
                        break;
                    }
                    case 10: {
                        temp = OracleParameterMetaDataParser.checkAndResizeBuffer(temp, tableIndex);
                        temp[tableIndex++] = unicodeChar;
                        break;
                    }
                    case 11: {
                        String t2;
                        if (tableIndex > 0 && (t2 = new String(temp, 0, tableIndex).trim()).length() > 0) {
                            this.tableName.add(t2);
                        }
                        tableIndex = 0;
                        break;
                    }
                    case 12: {
                        if (tableIndex <= 0) break;
                        String t2 = new String(temp, 0, tableIndex).trim();
                        if (t2.length() > 0) {
                            this.tableName.add(t2);
                        }
                        tableIndex = 0;
                        break;
                    }
                    case 13: {
                        String t2;
                        if (tableIndex > 0) {
                            t2 = new String(temp, 0, tableIndex).trim();
                            if (t2.length() > 0) {
                                this.tableName.add(t2);
                            }
                            tableIndex = 0;
                        }
                        if (this.tableName.isEmpty()) {
                            canSupportParameterMetaData = false;
                            break;
                        }
                        if (this.sqlKind == OracleStatement.SqlKind.INSERT) break;
                        columnIndex = 0;
                        temp = OracleParameterMetaDataParser.checkAndResizeBuffer(temp, columnIndex);
                        temp[columnIndex++] = unicodeChar;
                        break;
                    }
                    case 14: {
                        temp = OracleParameterMetaDataParser.checkAndResizeBuffer(temp, columnIndex);
                        temp[columnIndex++] = unicodeChar;
                        break;
                    }
                    case 15: {
                        String s1;
                        if (!canSupportParameterMetaData) break;
                        if (columnIndex > 0 && (s1 = new String(temp, 0, columnIndex)).trim().length() > 0) {
                            this.columnName.add(s1);
                        }
                        columnIndex = 0;
                        break;
                    }
                    case 16: {
                        String s1;
                        if (!canSupportParameterMetaData) break;
                        if (columnIndex > 0 && (s1 = new String(temp, 0, columnIndex)).trim().length() > 0) {
                            this.columnName.add(s1);
                        }
                        columnIndex = 0;
                        break;
                    }
                    case 17: {
                        canSupportParameterMetaData = false;
                        break;
                    }
                    case 21: {
                        jsonDelimiter.push(Character.valueOf(unicodeChar == '{' ? (char)'}' : ']'));
                        break;
                    }
                    case 22: {
                        if (jsonDelimiter.isEmpty()) break;
                        if (((Character)jsonDelimiter.peek()).charValue() == unicodeChar) {
                            jsonDelimiter.pop();
                        }
                        bindFound = false;
                        currentParameterLength = 0;
                    }
                }
                s2 = TRANSITION[s2][c2];
            }
            if (canSupportParameterMetaData) {
                if (this.sqlKind == OracleStatement.SqlKind.INSERT && lastBindCountPosition < lastBindPosition) {
                    if (this.bindStatusForInsert == null) {
                        this.bindStatusForInsert = new byte[50];
                    } else if (bindPositionIndex >= this.bindStatusForInsert.length) {
                        byte[] b3 = new byte[this.bindStatusForInsert.length << 1];
                        System.arraycopy(this.bindStatusForInsert, 0, b3, 0, this.bindStatusForInsert.length);
                        this.bindStatusForInsert = b3;
                    }
                    this.bindStatusForInsert[bindPositionIndex++] = 1;
                }
            } else {
                if (!this.tableName.isEmpty()) {
                    this.tableName.clear();
                }
                if (!this.columnName.isEmpty()) {
                    this.columnName.clear();
                }
                this.bindStatusForInsert = null;
                bindPositionIndex = -1;
            }
            this.needToParseSql = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static char[] checkAndResizeBuffer(char[] cArray, int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            char[] tmp;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$2, null, cArray, n2);
            }
            if (tmp.length <= index) {
                int len = tmp.length * 2;
                char[] buf = new char[len];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
                tmp = buf;
            }
            char[] cArray2 = tmp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$2, null, cArray2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$2, null, null);
            }
            return tmp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    String[] getColumnNames() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$3, this, new Object[0]);
            }
            String[] s2 = new String[this.columnName.size()];
            String[] stringArray = this.columnName.toArray(s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$3, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$3, this, null);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    String[] getTableNames() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$4, this, new Object[0]);
            }
            String[] s2 = new String[this.tableName.size()];
            String[] stringArray = this.tableName.toArray(s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$4, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$4, this, null);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getParameterMetaDataSql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.needToParseSql) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (this.sqlKind.isPlsqlOrCall() || this.parameterCount == 0) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            String[] _tableNames = this.getTableNames();
            if (_tableNames == null || _tableNames.length == 0) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            String[] _columnNames = this.getColumnNames();
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT ");
            if (_columnNames.length == 0) {
                if (this.sqlKind != OracleStatement.SqlKind.INSERT) {
                    String string = null;
                    if (!bl) return null;
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, null);
                    return null;
                }
                sb.append("* ");
            } else {
                boolean useBindStatusForInsert = this.bindStatusForInsert != null;
                int j2 = 0;
                for (int i2 = 0; i2 < _columnNames.length; ++i2) {
                    if (useBindStatusForInsert && this.bindStatusForInsert[i2] != 1) continue;
                    if (j2++ != 0) {
                        sb.append(", ");
                    }
                    sb.append(_columnNames[i2]);
                }
            }
            sb.append(" FROM ");
            for (int i3 = 0; i3 < _tableNames.length; ++i3) {
                if (i3 != 0) {
                    sb.append(", ");
                }
                sb.append(_tableNames[i3]);
            }
            String string = sb.substring(0, sb.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean needBindStatusForParameterMetaData() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.columnName.size() > 0 && this.parameterCount > 0 && this.bindStatusForInsert != null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$6, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getBindStatusForInsert() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$7, this, new Object[0]);
            }
            byte[] byArray = this.bindStatusForInsert;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$7, this, null);
            }
            return this.bindStatusForInsert;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String[] args;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null, new Object[]{stringArray});
            }
            String[] cases = null;
            if (args.length < 1) {
                System.err.println("ERROR: incorrect usage. OracleParameterMetaDataParser <-test| sql >");
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null, null);
                }
                return;
            }
            cases = "-test".equals(args[0]) ? new String[]{"insert into JAVA_KEYWORDS (\"ABSTRACT\",\"ASSERT\",\"BOOLEAN\",\"BREAK\",\"BYTE\",\"CASE\",\"CATCH\",\"CHAR\",\"CLASS\",\"CONST \",\"CONTINUE\",\"DEFAULT\",\"DO\",\"DOUBLE\",\"ELSE\",\"ENUM \",\"EXTENDS\",\"FINAL\",\"FINALLY\",\"FLOAT\",\"FOR\",\"GOTO \",\"IF\",\"IMPLEMENTS\",\"IMPORT\",\"INSTANCEOF\",\"INT\",\"INTERFACE\",\"LONG\",\"NATIVE\",\"NEW\",\"PACKAGE\",\"PRIVATE\",\"PROTECTED\",\"PUBLIC\",\"RETU RN\",\"SHORT\",\"STATIC\",\"STRICTFP \",\"SUPER\",\"SWITCH\",\"SYNCHRONIZED\",\"THIS\",\"THROW\",\"THROWS\",\"TRANS IENT\",\"TRY\",\"VOID\",\"VOLATILE\",\"WHILE\", \"ID\") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?  ,?,?,?,?,?,?,?,?,?,?,?,?)", "INSERT INTO emp(empno,ename,sal) VALUES(:B1, :b2, :b3)", "INSERT INTO T1 VALUES(:BIND1, :bind2)", "begin INSERT INTO T1 VALUES(:BIND1, :bind2); end;", "UPDATE T1 SET  C1 = :B1 and c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET C1 = :B1 and  c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET    C1 = :B1 and    c2 = :b2 and    c3 = 'abc' and c4 = :b4", "SELECT ename from emp where empno = :a1 and sal = :a2", "DELETE FROM EMP WHERE EMPNO>:x", "DELETE FROM EMP WHERE EMPNO   >   :1", "DELETE FROM EMP WHERE EMPNO\n>\n:2", "DELETE FROM EMP WHERE EMPNO\n<>\n:3", "DELETE FROM EMP WHERE EMPNO\n<>\n'abc'", "SELECT ename, d.deptno from emp e, dept d where empno = ?  and sal = ? and e.deptno = d.deptno", "SELECT ename, d.deptno from emp e, dept d where empno = :a1 and sal = :a2 and e.deptno = d.deptno", "SELECT ename, deptno   from    emp   , dept    where    empno =    :a1 and   sal = :a2", "SELECT * FROM TKPJST58_TAB WHERE C1 = :2", "SELECT * FROM TKPJST58_TAB WHERE C1 is null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is NULL  AND C2 = :1   AND C3 = :2   AND C4 = :3   AND C5 = :4   AND C6 = :5   AND C7 = :6   AND C8 = :7   AND C9 = :8   AND C10 = :9   AND C11 = :10   AND C12 = :11   AND C13 = :12   AND C14 = :13   AND C15 = :14   AND C16 is not null  AND C17 <> :15", "SELECT * FROM TKPJST58_TAB WHERE C1 = ?  AND C2 = ?  AND C3 = ?  AND C4 = ?  AND C5 = ?  AND C6 = ?  AND C7 = ?  AND C8 = ?  AND C9 = ?  AND C10 = ?  AND C11 = ?  AND C12 = ?  AND C13 = ?  AND C14 = ?  AND C15 = ?  AND C16 = ?  AND C17 = ?", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (?,?,?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,55,:4,:5)", "insert into rawtab values ('010203040506', '0708090a0b0c0d')", "begin insert into asciitab values (200,'21-sep-71',?,?,?); end;", "select col from dummy_tab where rowid=?", "SELECT * FROM test2 WHERE key >= ? ORDER BY key", "SELECT * FROM test2 WHERE key>=? ORDER BY key", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'})", "SELECT user FROM dual WHERE  ? < { fn LOCATE('TEST123TEST', 1) }", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'}, :3)", "delete from tkpjdg02_view where id >? returning id, name into ?, ?", "SELECT * FROM TABLE( CAST(? AS TYPE_VARCHAR_NT) )", "insert into (select t.col1 as column1, t.col2 as column2 from tkpjsc37 t  where t.col1 in (?,?,?,?)) values ( ?, ?)", "delete from tkpjdg02_view where id >? returning_id = ?", "insert into tkpjir93_tab values (?,q'!name LIKE '%DBMS_%%'!')", "insert into tkpjir93_tab values (?,q'{SELECT * FROM employees WHERE last_name = 'Smith';}'", "insert into xml_test values ('adf', '<?xml version=\"1.0\" encoding=\"UTF-8\"?><a></a>')", "SELECT * FROM test2 WHERE key>=? and ORDER_id=?  order BY key", "insert into emp(empno, ename, sal) values (?, N'abc', ?)", "UPDATE tkpjb5752856_tab SET c2=N'????C Mother''s Maiden Name????'", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (12,'abc',?,?,?,?,?,?)", "UPDATE /*abc*/T1 SET/*xyz*/ C1 = :B1 /*nyl*/and/*bac*/ c2 = :b2 and c3 = 'abc'", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/ null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/not--xyz\n null and c2 = :1 and c3 = :4", "UPDATE TKPJST58_TAB/*comment1*/set/*comment2*/ C1 = ?  WHERE  C4 = /*abc*/? ", "UPDATE TKPJST58_TAB set C1 = ?  and c2 = ? WHERE  C4 = /*abc*/? and c5 = ?"} : args;
            for (String testCase : cases) {
                try {
                    OracleSql o2 = new OracleSql(null);
                    o2.initialize(testCase);
                    String sql = o2.getSql(true, true);
                    System.out.println("SQL:" + sql);
                    System.out.println("  SqlKind:" + o2.sqlKind + ", Parameter Count=" + o2.parameterCount);
                    if (!o2.sqlKind.isPlsqlOrCall() && o2.parameterCount > 0) {
                        OracleParameterMetaDataParser opmdp = new OracleParameterMetaDataParser();
                        opmdp.initialize(sql, o2.sqlKind, o2.parameterCount);
                        System.out.println("  Parameter SQL: " + opmdp.getParameterMetaDataSql());
                    } else {
                        System.out.println("  Cannot get Parameter MetaData");
                    }
                    System.out.println("\n");
                }
                catch (Exception e2) {
                    System.out.println(e2);
                    e2.printStackTrace();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final void dumpTransitionMatrix(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$9, null, string);
            }
            try {
                String fileName;
                PrintWriter f2 = new PrintWriter(fileName);
                f2.print(",");
                for (int c2 = 0; c2 < 128; ++c2) {
                    f2.print("'" + (String)(c2 < 32 ? "0x" + Integer.toHexString(c2) : Character.toString((char)c2)) + (c2 < 127 ? "'," : "'"));
                }
                f2.println();
                int[][] m2 = OracleParameterMetaDataParserStates.TRANSITION;
                String[] n2 = OracleParameterMetaDataParserStates.PARSER_STATE_NAME;
                for (int s2 = 0; s2 < TRANSITION.length; ++s2) {
                    f2.print(n2[s2] + ",");
                    for (int c3 = 0; c3 < m2[s2].length; ++c3) {
                        f2.print(n2[m2[s2][c3]] + (c3 < 127 ? "," : ""));
                    }
                    f2.println();
                }
                f2.close();
            }
            catch (Throwable e2) {
                System.err.println(e2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$10, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$10, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleParameterMetaDataParser.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = OracleParameterMetaDataParser.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleParameterMetaDataParser.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleParameterMetaDataParser.class.getDeclaredMethod("dumpTransitionMatrix", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleParameterMetaDataParser.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleParameterMetaDataParser.class.getDeclaredMethod("getBindStatusForInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleParameterMetaDataParser.class.getDeclaredMethod("needBindStatusForParameterMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleParameterMetaDataParser.class.getDeclaredMethod("getParameterMetaDataSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleParameterMetaDataParser.class.getDeclaredMethod("getTableNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleParameterMetaDataParser.class.getDeclaredMethod("getColumnNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleParameterMetaDataParser.class.getDeclaredMethod("checkAndResizeBuffer", char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleParameterMetaDataParser.class.getDeclaredMethod("computeBasicInfo", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleParameterMetaDataParser.class.getDeclaredMethod("initialize", String.class, OracleStatement.SqlKind.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        EMPTY_LIST = new String[0];
        TRANSITION = OracleParameterMetaDataParserStates.TRANSITION;
        ACTION = OracleParameterMetaDataParserStates.ACTION;
    }
}

