/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

public class EnvVariableResolver {
    private static final boolean IS_WINDOWS_FILE_SYSTEM;
    private static final Pattern PLACE_HOLDER_PATTERN;
    private static final String TNS_ADMIN = "TNS_ADMIN";
    private static final List<Character> SUPPORTED_PRE_CHARS;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public static String resolveEnvPlaceHolders(String inputString, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(inputString);
        StringBuffer outputBuffer = new StringBuffer();
        while (matcher.find()) {
            String key;
            String value;
            String match = matcher.group(1);
            if (match == null || match.length() < 4 || (value = EnvVariableResolver.getEnvValue(key = match.substring(2, match.length() - 1), userProps)) == null) continue;
            matcher.appendReplacement(outputBuffer, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(outputBuffer);
        return outputBuffer.toString();
    }

    public static String resolveFilePath(String filePath, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        if (EnvVariableResolver.checkIfFileExists(filePath)) {
            return filePath;
        }
        return new EnvKeyParser(filePath.toCharArray()).traverse(userProps);
    }

    private static boolean checkIfFileExists(String inputString) {
        File file = new File(inputString);
        return file.exists();
    }

    private static String getEnvValue(String envKey, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        if (envKey.equalsIgnoreCase(TNS_ADMIN) && userProps.containsKey("oracle.net.tns_admin")) {
            return userProps.getProperty("oracle.net.tns_admin");
        }
        String returnValue = System.getProperty(envKey);
        if (returnValue == null) {
            try {
                returnValue = AccessController.doPrivileged(() -> System.getenv(envKey));
            }
            catch (SecurityException e2) {
                return null;
            }
        }
        return returnValue;
    }

    static {
        try {
            $$$methodRef$$$5 = EnvVariableResolver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = EnvVariableResolver.class.getDeclaredMethod("lambda$getEnvValue$0", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = EnvVariableResolver.class.getDeclaredMethod("getEnvValue", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = EnvVariableResolver.class.getDeclaredMethod("checkIfFileExists", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = EnvVariableResolver.class.getDeclaredMethod("resolveFilePath", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = EnvVariableResolver.class.getDeclaredMethod("resolveEnvPlaceHolders", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        IS_WINDOWS_FILE_SYSTEM = File.separator.equals("\\");
        PLACE_HOLDER_PATTERN = Pattern.compile("(\\$\\{.*?\\})");
        SUPPORTED_PRE_CHARS = IS_WINDOWS_FILE_SYSTEM ? Arrays.asList(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':')) : Arrays.asList(Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':'));
    }

    private static class EnvKeyParser {
        private final char[] input;
        private final StringBuilder outputBuffer;
        private int currentIndex = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private EnvKeyParser(char[] input) {
            this.input = input;
            this.outputBuffer = new StringBuilder();
        }

        public String traverse(@Blind(value=PropertiesBlinder.class) Properties userProp) {
            char prevChar = ' ';
            while (this.currentIndex < this.input.length) {
                switch (this.input[this.currentIndex]) {
                    case '$': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(prevChar))) {
                            this.lookForLinuxEnvReplacement(userProp);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    case '%': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(prevChar))) {
                            this.lookForWindowsEnvReplacement(userProp);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    default: {
                        this.outputBuffer.append(this.input[this.currentIndex]);
                    }
                }
                if (this.currentIndex < this.input.length && !Character.isWhitespace(this.input[this.currentIndex])) {
                    prevChar = this.input[this.currentIndex];
                }
                ++this.currentIndex;
            }
            return this.outputBuffer.toString();
        }

        private boolean lookForWindowsEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties userProps) {
            String keyStr;
            String keyVal;
            StringBuilder key = new StringBuilder();
            StringBuilder actualSeq = new StringBuilder();
            actualSeq.append(this.input[this.currentIndex]);
            boolean envTerminatorFound = false;
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                actualSeq.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '%') {
                    envTerminatorFound = true;
                    break;
                }
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    key.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if (envTerminatorFound && (keyVal = EnvVariableResolver.getEnvValue(keyStr = key.toString(), userProps)) != null) {
                this.outputBuffer.append(keyVal);
                return true;
            }
            this.outputBuffer.append(actualSeq.toString());
            return false;
        }

        private boolean lookForLinuxEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties userProps) {
            String keyStr;
            String keyVal;
            StringBuilder actualSeq = new StringBuilder();
            actualSeq.append(this.input[this.currentIndex]);
            StringBuilder key = new StringBuilder();
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                actualSeq.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '/') break;
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    key.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if ((keyVal = EnvVariableResolver.getEnvValue(keyStr = key.toString(), userProps)) != null) {
                this.outputBuffer.append(keyVal);
                if (this.currentIndex < this.input.length) {
                    this.outputBuffer.append(this.input[this.currentIndex]);
                }
                return true;
            }
            this.outputBuffer.append(actualSeq.toString());
            return false;
        }

        static {
            try {
                $$$methodRef$$$3 = EnvKeyParser.class.getDeclaredConstructor(char[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = EnvKeyParser.class.getDeclaredMethod("lookForLinuxEnvReplacement", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = EnvKeyParser.class.getDeclaredMethod("lookForWindowsEnvReplacement", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = EnvKeyParser.class.getDeclaredMethod("traverse", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

