// SPDX-License-Identifier: Apache-2.0
/*
Copyright (C) 2024 The Falco Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/
#pragma once

#include <libsinsp/sinsp_thread_pool.h>

namespace BS {
class thread_pool;
};

class sinsp_thread_pool_bs : public sinsp_thread_pool {
public:
	sinsp_thread_pool_bs(size_t num_workers = 0);

	virtual ~sinsp_thread_pool_bs() { purge(); }

	sinsp_thread_pool::routine_id_t subscribe(const std::function<bool()>& func);

	bool unsubscribe(sinsp_thread_pool::routine_id_t id);

	void purge();

	size_t routines_num();

private:
	struct default_bs_tp_deleter {
		void operator()(BS::thread_pool* __ptr) const;
	};

	void run_routine(std::shared_ptr<std::function<bool()>> id);

	std::unique_ptr<BS::thread_pool, default_bs_tp_deleter> m_pool;
	std::list<std::shared_ptr<std::function<bool()>>> m_routines;
};
