/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGColorManager;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String prop) {
        super(prop);
    }

    public SVGPaintManager(String prop, Value v) {
        super(prop, v);
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 7;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        Value uriVal = null;
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                if (lu.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lu, engine);
            }
            case URI: {
                uriVal = this.createURIValue(lu, engine);
                break;
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lu);
            }
        }
        if (uriVal == null) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return uriVal;
        }
        ListValue result = new ListValue(' ');
        result.append(uriVal);
        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lu.getStringValue().equalsIgnoreCase("none")) {
            result.append(ValueConstants.NONE_VALUE);
            return result;
        }
        Value v = super.createValue(lu, engine);
        if (v instanceof ListValue) {
            for (int i = 0; i < v.getLength(); ++i) {
                result.append(v.item(i));
            }
        } else {
            result.append(v);
        }
        return result;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        Value v;
        if (value.isIdentifier("none")) {
            return value;
        }
        if (value.getCssValueType() == CSSValue.CssType.LIST && (v = value.item(0)).getPrimitiveType() == CSSValue.Type.URI) {
            if (sm.isAttrTainted(idx)) {
                CSSEngineUserAgent ua = engine.getCSSEngineUserAgent();
                if (ua != null) {
                    ua.warn("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
            v = value.item(1);
            if (v == null || v.isIdentifier("none")) {
                return value;
            }
            Value t = super.computeValue(elt, pseudo, engine, idx, sm, v);
            if (t != v) {
                ListValue result = new ListValue(' ');
                result.append(value.item(0));
                result.append(t);
                if (value.getLength() == 3) {
                    result.append(value.item(1));
                }
                return result;
            }
            return value;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }
}

