/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.decode;

import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.decode.DecodedStride;
import ghidra.pcode.emu.jit.decode.DecoderExecutor;
import ghidra.pcode.emu.jit.decode.DecoderForOnePassage;
import ghidra.pcode.emu.jit.decode.JitPassageDecoder;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import java.util.ArrayList;
import java.util.List;

public class DecoderForOneStride {
    final JitPassageDecoder decoder;
    final DecoderForOnePassage passage;
    private final JitPassage.AddrCtx start;
    final List<Instruction> instructions = new ArrayList<Instruction>();
    final List<PcodeOp> opsForStride = new ArrayList<PcodeOp>();

    public DecoderForOneStride(JitPassageDecoder decoder, DecoderForOnePassage passage, JitPassage.AddrCtx start) {
        this.decoder = decoder;
        this.passage = passage;
        this.start = start;
    }

    DecodedStride toStride() {
        return new DecodedStride(this.start, this.instructions, this.opsForStride);
    }

    private StepResult stepAddrCtx(JitPassage.AddrCtx at) {
        if (this.decoder.thread.hasEntry(at)) {
            JitPassage.ExitPcodeOp exitOp = JitPassage.ExitPcodeOp.exit(at);
            this.opsForStride.add(exitOp);
            this.passage.otherBranches.put(exitOp, new JitPassage.RExtBranch(exitOp, at, JitPassage.Reachability.WITHOUT_CTXMOD));
            return null;
        }
        DecoderExecutor executor = new DecoderExecutor(this, at);
        PcodeProgram program = this.decoder.thread.getInject(at.address);
        if (program == null) {
            PseudoInstruction instruction = executor.decodeInstruction();
            this.instructions.add((Instruction)instruction);
            program = PcodeProgram.fromInstruction((Instruction)instruction, false);
        }
        executor.execute(program);
        if (executor.opsForThisStep.isEmpty()) {
            JitPassage.NopPcodeOp nop = new JitPassage.NopPcodeOp(at, 0);
            this.passage.firstOps.put(at, nop);
            this.opsForStride.add(nop);
        } else {
            this.passage.firstOps.put(at, executor.opsForThisStep.getFirst());
        }
        return new StepResult(executor, program);
    }

    public DecodedStride decode() {
        JitPassage.AddrCtx at = this.start;
        block5: while (!this.passage.firstOps.containsKey(at)) {
            JitPassage.ExitPcodeOp exitOp;
            StepResult result = this.stepAddrCtx(at);
            if (result == null) {
                return this.toStride();
            }
            JitPassage.Reachability reach = result.checkFallthroughAndAccumulate();
            if (reach == null) {
                return this.toStride();
            }
            JitPassage.AddrCtx next = result.next();
            if (at.equals(next)) {
                exitOp = JitPassage.ExitPcodeOp.exit(at);
                this.opsForStride.add(exitOp);
                this.passage.otherBranches.put(exitOp, new JitPassage.RExtBranch(exitOp, at, reach));
                return this.toStride();
            }
            at = next;
            switch (reach) {
                case WITHOUT_CTXMOD: {
                    continue block5;
                }
                case WITH_CTXMOD: {
                    exitOp = JitPassage.ExitPcodeOp.exit(at);
                    this.opsForStride.add(exitOp);
                    this.passage.otherBranches.put(exitOp, new JitPassage.RExtBranch(exitOp, at, reach));
                    return this.toStride();
                }
                case MAYBE_CTXMOD: {
                    exitOp = JitPassage.ExitPcodeOp.cond(at);
                    this.opsForStride.add(exitOp);
                    this.passage.otherBranches.put(exitOp, new JitPassage.RExtBranch(exitOp, at, reach));
                    continue block5;
                }
            }
        }
        return this.toStride();
    }

    record StepResult(DecoderExecutor executor, PcodeProgram program) {
        JitPassage.Reachability checkFallthroughAndAccumulate() {
            return this.executor.checkFallthroughAndAccumulate(this.program);
        }

        JitPassage.AddrCtx next() {
            return this.executor.takeTargetContext(this.executor.getAdvancedAddress());
        }
    }
}

