/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Collection;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.DFSCycleRemoval;

public class DFSFeedbackArcGraphTransformer<V, E>
implements Function<Graph<V, E>, Graph<V, E>> {
    Function<E, E> edgeFactory;

    public DFSFeedbackArcGraphTransformer(Function<E, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    @Override
    public Graph<V, E> apply(Graph<V, E> graph) {
        DFSCycleRemoval<V, E> greedyCycleRemoval = new DFSCycleRemoval<V, E>(graph);
        Collection<E> feedbackArcs = greedyCycleRemoval.getFeedbackArcs();
        for (E se : feedbackArcs) {
            Object source = graph.getEdgeSource(se);
            Object target = graph.getEdgeTarget(se);
            graph.removeEdge(se);
            E newEdge = this.edgeFactory.apply(se);
            graph.addEdge(target, source, newEdge);
        }
        return graph;
    }
}

