/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DexLoader
extends AbstractProgramWrapperLoader {
    public String getName() {
        return "Dalvik Executable (DEX)";
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        BinaryReader reader = new BinaryReader(provider, true);
        try {
            DexHeader header = DexHeaderFactory.getDexHeader(reader);
            if ("dex\n".equals(new String(header.getMagic()))) {
                List queries = QueryOpinionService.query((String)this.getName(), (String)"1", null);
                for (QueryResult result : queries) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadSpecs;
    }

    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        monitor.setMessage(this.getMonitorMessagePrimary());
        try {
            Address start = program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
            long length = provider.length();
            try (InputStream inputStream = provider.getInputStream(0L);){
                program.getMemory().createInitializedBlock(this.getMemoryBlockName(), start, inputStream, length, monitor, false);
            }
            BinaryReader reader = new BinaryReader(provider, true);
            DexHeader header = DexHeaderFactory.getDexHeader(reader);
            monitor.setMessage(this.getMonitorMessageSecondary());
            this.createMethodLookupMemoryBlock(program, monitor);
            this.createMethodByteCodeBlock(program, length, monitor);
            for (ClassDefItem item : header.getClassDefs()) {
                monitor.checkCancelled();
                ClassDataItem classDataItem = item.getClassDataItem();
                if (classDataItem == null) continue;
                this.createMethods(program, header, item, classDataItem.getDirectMethods(), monitor, log);
                this.createMethods(program, header, item, classDataItem.getVirtualMethods(), monitor, log);
            }
            this.markupMethodLookup(program, header, monitor, log);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    protected void createMethodByteCodeBlock(Program program, long length, TaskMonitor monitor) throws Exception {
        Address address = this.toAddr(program, 0x50000000L);
        MemoryBlock block = program.getMemory().createInitializedBlock("method_bytecode", address, length, (byte)-1, monitor, false);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(true);
    }

    protected void createMethodLookupMemoryBlock(Program program, TaskMonitor monitor) throws Exception {
        Address address = this.toAddr(program, 0xE0000000L);
        MemoryBlock block = program.getMemory().createInitializedBlock("method_lookup", address, 524288L, (byte)-1, monitor, false);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
    }

    protected void createMethods(Program program, DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor, MessageLog log) throws Exception {
        for (EncodedMethod encodedMethod : methods) {
            monitor.checkCancelled();
            CodeItem codeItem = encodedMethod.getCodeItem();
            Address methodIndexAddress = DexUtil.toLookupAddress(program, encodedMethod.getMethodIndex());
            if (codeItem == null) continue;
            Address methodAddress = this.toAddr(program, 0x50000000L + (long)encodedMethod.getCodeOffset());
            byte[] instructionBytes = codeItem.getInstructionBytes();
            program.getMemory().setBytes(methodAddress, instructionBytes);
            program.getMemory().setInt(methodIndexAddress, (int)methodAddress.getOffset());
        }
    }

    protected void markupMethodLookup(Program program, DexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: processing methods");
        monitor.setMaximum((long)header.getMethodIdsSize());
        monitor.setProgress(0L);
        int methodIndex = 0;
        for (MethodIDItem item : header.getMethods()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            StringBuilder builder = new StringBuilder();
            builder.append("Method Index: 0x" + Integer.toHexString(methodIndex) + "\n");
            builder.append("Class: " + DexUtil.convertTypeIndexToString(header, item.getClassIndex()) + "\n");
            builder.append("Prototype: " + DexUtil.convertPrototypeIndexToString(header, item.getProtoIndex()) + "\n");
            builder.append("Name: " + DexUtil.convertToString(header, item.getNameIndex()) + "\n");
            Address methodIndexAddress = DexUtil.toLookupAddress(program, methodIndex);
            if (program.getMemory().getInt(methodIndexAddress) == -1) {
                Address externalAddress;
                Symbol methodSymbol;
                program.getListing().setComment(methodIndexAddress, CommentType.PLATE, builder.toString());
                String methodName = DexUtil.convertToString(header, item.getNameIndex());
                String className = DexUtil.convertTypeIndexToString(header, item.getClassIndex());
                Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
                if (classNameSpace != null && (methodSymbol = this.createMethodSymbol(program, externalAddress = DexUtil.toLookupAddress(program, methodIndex), methodName, classNameSpace, log)) != null) {
                    String externalName = methodSymbol.getName(true);
                    program.getReferenceManager().addExternalReference(methodIndexAddress, "EXTERNAL.dex-" + methodIndex, externalName, null, SourceType.ANALYSIS, 0, RefType.DATA);
                }
            }
            program.getListing().createData(methodIndexAddress, (DataType)new PointerDataType());
            ++methodIndex;
        }
    }

    private Symbol createMethodSymbol(Program program, Address methodAddress, String methodName, Namespace classNameSpace, MessageLog log) {
        program.getSymbolTable().addExternalEntryPoint(methodAddress);
        try {
            return program.getSymbolTable().createLabel(methodAddress, methodName, classNameSpace, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
            return null;
        }
    }

    protected Address toAddr(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    protected String getMemoryBlockName() {
        return ".dex";
    }

    protected String getMonitorMessagePrimary() {
        return "DEX Loader: creating dex memory";
    }

    protected String getMonitorMessageSecondary() {
        return "DEX Loader: creating method byte code";
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return Collections.emptyList();
    }

    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        return null;
    }
}

