/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cart.CartInvalidARC4KeyException;
import ghidra.file.formats.cart.CartInvalidCartException;
import ghidra.file.formats.cart.CartV1Decryptor;
import java.io.IOException;

public class CartV1Footer {
    private String magic;
    private long reserved = -1L;
    private long optionalFooterPosition = -1L;
    private long optionalFooterLength = -1L;
    private JsonObject optionalFooterData;
    private long footerPosition = -1L;
    private long readerLength = -1L;
    private BinaryReader internalReader;

    public CartV1Footer(ByteProvider byteProvider) throws IOException, CartInvalidCartException {
        this(new BinaryReader(byteProvider, true));
    }

    public CartV1Footer(BinaryReader reader) throws IOException, CartInvalidCartException {
        if (!reader.isLittleEndian()) {
            throw new IOException("CaRT BinaryReader must be Little-Endian.");
        }
        this.readerLength = reader.length();
        if (this.readerLength < 28L) {
            throw new CartInvalidCartException("Data too small to contain CaRT footer.");
        }
        this.footerPosition = this.readerLength - 28L;
        if (this.footerPosition < 0L || this.footerPosition > this.readerLength) {
            throw new CartInvalidCartException("Invalid CaRT footer position.");
        }
        this.internalReader = reader.clone(this.footerPosition);
        this.magic = this.internalReader.readNextAsciiString("TRAC".length());
        if (!this.magic.equals("TRAC")) {
            throw new CartInvalidCartException("Invalid CaRT footer magic value.");
        }
        this.reserved = this.internalReader.readNextLong();
        if (this.reserved != 0L) {
            throw new CartInvalidCartException("Invalid CaRT footer reserved value.");
        }
        this.optionalFooterPosition = this.internalReader.readNextLong();
        if (this.optionalFooterPosition < 0L || this.optionalFooterPosition > this.footerPosition || this.optionalFooterPosition > this.readerLength) {
            throw new CartInvalidCartException("Invalid CaRT optional footer position.");
        }
        this.optionalFooterLength = this.internalReader.readNextLong();
        if (this.optionalFooterLength < 0L || this.optionalFooterPosition + this.optionalFooterLength != this.footerPosition || this.optionalFooterPosition + this.optionalFooterLength > this.readerLength) {
            throw new CartInvalidCartException("Invalid CaRT optional footer length.");
        }
    }

    protected String magic() throws CartInvalidCartException {
        return this.magic;
    }

    protected long optionalFooterPosition() throws CartInvalidCartException {
        return this.optionalFooterPosition;
    }

    protected long optionalFooterLength() throws CartInvalidCartException {
        return this.optionalFooterLength;
    }

    protected JsonObject optionalFooterData() throws CartInvalidCartException {
        JsonObject optionalFooterDataCopy = this.optionalFooterData != null ? this.optionalFooterData.deepCopy() : null;
        return optionalFooterDataCopy;
    }

    public JsonObject loadOptionalFooter(CartV1Decryptor decryptor) throws CartInvalidCartException, CartInvalidARC4KeyException, IOException {
        byte[] encryptedOptionalFooter = null;
        if (this.optionalFooterLength > 0L && this.optionalFooterPosition + this.optionalFooterLength == this.footerPosition && this.optionalFooterPosition + this.optionalFooterLength < this.readerLength) {
            try {
                encryptedOptionalFooter = this.internalReader.readByteArray(this.optionalFooterPosition, (int)this.optionalFooterLength);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (encryptedOptionalFooter != null) {
            String decryptedOptionalFooter = decryptor.decryptToString(encryptedOptionalFooter);
            if (decryptedOptionalFooter == null) {
                throw new CartInvalidARC4KeyException("CaRT optional footer decryption failed.");
            }
            try {
                this.optionalFooterData = JsonParser.parseString((String)decryptedOptionalFooter).getAsJsonObject();
            }
            catch (JsonSyntaxException | IllegalStateException e) {
                throw new CartInvalidARC4KeyException("CaRT decrypted optional footer not valid JSON.");
            }
        }
        if (this.optionalFooterData == null) {
            this.optionalFooterData = new JsonObject();
        }
        return this.optionalFooterData();
    }
}

