/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SystemInfoStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_SYSTEM_INFO";
    private short processorArchitecture;
    private short processorLevel;
    private short processorRevision;
    private byte numberOfProcessors;
    private byte productType;
    private int majorVersion;
    private int minorVersion;
    private int buildNumber;
    private int platformId;
    private int rva;
    private short suiteMask;
    private int[] vendorId = new int[3];
    private int versionInformation;
    private int featureInformation;
    private int AMDExtendedCpuFeatures;
    private int csdNameLength;
    private String csdName;
    private DumpFileReader reader;
    private long index;

    SystemInfoStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
        this.getRVAs();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setProcessorArchitecture(this.reader.readNextShort());
        this.setProcessorLevel(this.reader.readNextShort());
        this.setProcessorRevision(this.reader.readNextShort());
        this.setNumberOfProcessors(this.reader.readNextByte());
        this.setProductType(this.reader.readNextByte());
        this.setMajorVersion(this.reader.readNextInt());
        this.setMinorVersion(this.reader.readNextInt());
        this.setBuildNumber(this.reader.readNextInt());
        this.setPlatformId(this.reader.readNextInt());
        this.setCSDRevisionRVA(this.reader.readNextInt());
        this.setSuiteMask(this.reader.readNextShort());
        this.reader.readNextShort();
        for (int i = 0; i < 3; ++i) {
            this.setVendorId(this.reader.readNextInt(), i);
        }
        this.setVersionInformation(this.reader.readNextInt());
        this.setFeatureInformation(this.reader.readNextInt());
        this.setAMDExtendedCpuFeatures(this.reader.readNextInt());
    }

    private void getRVAs() throws IOException {
        long pos = this.reader.getPointerIndex();
        this.reader.setPointerIndex(this.getCSDVersionRVA());
        this.csdNameLength = this.reader.readNextInt();
        this.csdName = this.reader.readNextUnicodeString();
        this.reader.setPointerIndex(pos);
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, 2, "ProcessorArchitecture", null);
        struct.add(WORD, 2, "ProcessorLevel", null);
        struct.add(WORD, 2, "ProcessorRevision", null);
        UnionDataType u0 = new UnionDataType("MINIDUMP_SYSTEM_INFO_u0");
        u0.add(WORD, 2, "Reserved0", null);
        StructureDataType s0 = new StructureDataType("MINIDUMP_SYSTEM_INFO_s0", 0);
        s0.add(BYTE, 1, "NumberOfProcessors", null);
        s0.add(BYTE, 1, "ProductType", null);
        u0.add((DataType)s0, 2, s0.getDisplayName(), null);
        struct.add((DataType)u0, u0.getLength(), u0.getDisplayName(), null);
        struct.add(DWORD, 4, "MajorVersion", null);
        struct.add(DWORD, 4, "MinorVersion", null);
        struct.add(DWORD, 4, "BuildNumber", null);
        struct.add(DWORD, 4, "PlatformId", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "CSDVersionRVA", null);
        UnionDataType u1 = new UnionDataType("MINIDUMP_SYSTEM_INFO_u1");
        u1.add(DWORD, 4, "Reserved1", null);
        StructureDataType s1 = new StructureDataType("MINIDUMP_SYSTEM_INFO_s1", 0);
        s1.add(WORD, 2, "SuiteMask", null);
        s1.add(WORD, 2, "Reserved1", null);
        u1.add((DataType)s1, 2, s1.getDisplayName(), null);
        struct.add((DataType)u1, u1.getLength(), u1.getDisplayName(), null);
        UnionDataType u2 = new UnionDataType("CPU_INFORMATION");
        StructureDataType s3 = new StructureDataType("X86CpuInfo", 0);
        ArrayDataType a0 = new ArrayDataType(DWORD, 3, 4);
        s3.add((DataType)a0, a0.getLength(), "VendorId", null);
        s3.add(DWORD, 4, "VersionInformation", null);
        s3.add(DWORD, 4, "FeatureInformation", null);
        s3.add(DWORD, 4, "AMDExtendedCpuFeatures", null);
        StructureDataType s4 = new StructureDataType("OtherCpuInfo", 0);
        ArrayDataType a1 = new ArrayDataType(QWORD, 2, 8);
        s4.add((DataType)a1, a1.getLength(), "ProcessorFeatures", null);
        u2.add((DataType)s3, s3.getLength(), s3.getDisplayName(), null);
        u2.add((DataType)s4, s4.getLength(), s4.getDisplayName(), null);
        struct.add((DataType)u2, u2.getLength(), u2.getDisplayName(), null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public short getProcessorArchitecture() {
        return this.processorArchitecture;
    }

    public void setProcessorArchitecture(short processorArchitecture) {
        this.processorArchitecture = processorArchitecture;
    }

    public short getProcessorLevel() {
        return this.processorLevel;
    }

    public void setProcessorLevel(short processorLevel) {
        this.processorLevel = processorLevel;
    }

    public short getProcessorRevision() {
        return this.processorRevision;
    }

    public void setProcessorRevision(short processorRevision) {
        this.processorRevision = processorRevision;
    }

    public byte getNumberOfProcessors() {
        return this.numberOfProcessors;
    }

    public void setNumberOfProcessors(byte numberOfProcessors) {
        this.numberOfProcessors = numberOfProcessors;
    }

    public byte getProductType() {
        return this.productType;
    }

    public void setProductType(byte productType) {
        this.productType = productType;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformId) {
        this.platformId = platformId;
    }

    public int getCSDVersionRVA() {
        return this.rva;
    }

    public void setCSDRevisionRVA(int rva) {
        this.rva = rva;
    }

    public short getSuiteMask() {
        return this.suiteMask;
    }

    public void setSuiteMask(short suiteMask) {
        this.suiteMask = suiteMask;
    }

    public int getVendorId(int idx) {
        return this.vendorId[idx];
    }

    public void setVendorId(int vendorId, int index) {
        this.vendorId[index] = vendorId;
    }

    public int getVersionInformation() {
        return this.versionInformation;
    }

    public void setVersionInformation(int versionInformation) {
        this.versionInformation = versionInformation;
    }

    public int getFeatureInformation() {
        return this.featureInformation;
    }

    public void setFeatureInformation(int featureInformation) {
        this.featureInformation = featureInformation;
    }

    public int getAMDExtendedCpuFeatures() {
        return this.AMDExtendedCpuFeatures;
    }

    public void setAMDExtendedCpuFeatures(int extendedCpuFeatures) {
        this.AMDExtendedCpuFeatures = extendedCpuFeatures;
    }

    public int getCSDNameLength() {
        return this.csdNameLength;
    }

    public String getCSDName() {
        return this.csdName;
    }
}

