/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import io.netty.handler.ipfilter.PatternRule;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class IpFilterRuleList
extends ArrayList<IpFilterRule> {
    private static final long serialVersionUID = -6164162941749588780L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IpFilterRuleList.class);

    public IpFilterRuleList(String rules) {
        this.parseRules(rules);
    }

    private void parseRules(String rules) {
        String[] ruless;
        for (String rule : ruless = rules.split(",")) {
            this.parseRule(rule.trim());
        }
    }

    private void parseRule(String rule) {
        if (rule == null || rule.length() == 0) {
            return;
        }
        if (!rule.startsWith("+") && !rule.startsWith("-")) {
            logger.error("syntax error in ip filter rule:" + rule);
            return;
        }
        boolean allow = rule.startsWith("+");
        if (rule.charAt(1) == 'n' || rule.charAt(1) == 'i') {
            this.add(new PatternRule(allow, rule.substring(1)));
        } else if (rule.charAt(1) == 'c') {
            try {
                this.add(new IpSubnetFilterRule(allow, rule.substring(3)));
            }
            catch (UnknownHostException e) {
                logger.error("error parsing ip filter " + rule, (Throwable)e);
            }
        } else {
            logger.error("syntax error in ip filter rule:" + rule);
        }
    }
}

