/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.pcode.floatformat.UnsupportedFloatFormatException;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;
import java.math.BigDecimal;

public class ConvertDoubleAction
extends ConvertConstantAction {
    public ConvertDoubleAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Double", 7);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Double"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Double: ";
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        return this.getText(value, size, isSigned, program);
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        return this.getText(value, size, isSigned, program);
    }

    private String getText(long value, int size, boolean isSigned, Program program) {
        Scalar scalar;
        DataOrganization organization = program.getDataTypeManager().getDataOrganization();
        int doubleSize = organization.getDoubleSize();
        BigDecimal bd = ConvertDoubleAction.value(doubleSize, scalar = new Scalar(size * 8, value));
        if (bd != null) {
            return bd.toString();
        }
        return null;
    }

    private static BigDecimal value(int size, Scalar s) {
        try {
            FloatFormat format = FloatFormatFactory.getFloatFormat((int)size);
            return format.round(format.decodeBigFloat(s.getBigInteger()));
        }
        catch (UnsupportedFloatFormatException e) {
            return null;
        }
    }
}

