/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.protocol.AdjustVectorIndex;
import ghidra.features.bsim.query.protocol.CreateDatabase;
import ghidra.features.bsim.query.protocol.InsertRequest;
import ghidra.features.bsim.query.protocol.InstallCategoryRequest;
import ghidra.features.bsim.query.protocol.InstallMetadataRequest;
import ghidra.features.bsim.query.protocol.InstallTagRequest;
import ghidra.features.bsim.query.protocol.PasswordChange;
import ghidra.features.bsim.query.protocol.PrewarmRequest;
import ghidra.features.bsim.query.protocol.QueryChildren;
import ghidra.features.bsim.query.protocol.QueryCluster;
import ghidra.features.bsim.query.protocol.QueryDelete;
import ghidra.features.bsim.query.protocol.QueryInfo;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryPair;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.QueryUpdate;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public abstract class BSimQuery<R extends QueryResponseRecord> {
    protected final String name;
    protected R response;

    public BSimQuery(String name) {
        this.name = name;
        this.response = null;
    }

    public final R execute(FunctionDatabase database) {
        return (R)database.query(this);
    }

    public void clearResponse() {
        this.response = null;
    }

    public R getResponse() {
        return this.response;
    }

    public String getName() {
        return this.name;
    }

    public void buildResponseTemplate() {
    }

    public abstract void saveXml(Writer var1) throws IOException;

    public abstract void restoreXml(XmlPullParser var1, LSHVectorFactory var2) throws LSHException;

    public DescriptionManager getDescriptionManager() {
        return null;
    }

    public BSimQuery<?> getLocalStagingCopy() {
        return null;
    }

    public static BSimQuery<?> restoreQuery(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        BSimQuery query;
        String mainName = parser.peek().getName();
        if (mainName.equals("querynearest")) {
            query = new QueryNearest();
        } else if (mainName.equals("querynearestvector")) {
            query = new QueryNearestVector();
        } else if (mainName.equals("insert")) {
            query = new InsertRequest();
        } else if (mainName.equals("queryinfo")) {
            query = new QueryInfo();
        } else if (mainName.equals("update")) {
            query = new QueryUpdate();
        } else if (mainName.equals("queryname")) {
            query = new QueryName();
        } else if (mainName.equals("delete")) {
            query = new QueryDelete();
        } else if (mainName.equals("createdatabase")) {
            query = new CreateDatabase();
        } else if (mainName.equals("querychildren")) {
            query = new QueryChildren();
        } else if (mainName.equals("querycluster")) {
            query = new QueryCluster();
        } else if (mainName.equals("querypair")) {
            query = new QueryPair();
        } else if (mainName.equals("installcategory")) {
            query = new InstallCategoryRequest();
        } else if (mainName.equals("installmetadata")) {
            query = new InstallMetadataRequest();
        } else if (mainName.equals("installtag")) {
            query = new InstallTagRequest();
        } else if (mainName.equals("adjustindex")) {
            query = new AdjustVectorIndex();
        } else if (mainName.equals("passwordchange")) {
            query = new PasswordChange();
        } else if (mainName.equals("prewarmrequest")) {
            query = new PrewarmRequest();
        } else {
            throw new LSHException("Unknown query tag: " + mainName);
        }
        ((BSimQuery)query).restoreXml(parser, vectorFactory);
        return query;
    }
}

