/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeSelectingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(EdgeSelectingGraphMousePlugin.class);
    private static final int TOO_CLOSE_LIMIT = 5;
    private static final String PICK_AREA_SIZE = "jungrapht.pickAreaSize";
    protected int pickSize = Integer.getInteger("jungrapht.pickAreaSize", 4);
    protected E edge;
    protected Rectangle2D footprintRectangle = new Rectangle2D.Float();
    protected VisualizationServer.Paintable pickFootprintPaintable;
    protected Color lensColor = Color.cyan;
    protected Point2D deltaDown;
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;

    public EdgeSelectingGraphMousePlugin(int singleSelectionMask, int toggleSingleSelectionMask) {
        this.singleSelectionMask = singleSelectionMask;
        this.toggleSingleSelectionMask = toggleSingleSelectionMask;
        this.pickFootprintPaintable = new FootprintPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        this.down = e.getPoint();
        log.trace("mouse pick at screen coords {}", (Object)e.getPoint());
        this.deltaDown = this.down;
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        TransformSupport transformSupport = vv.getTransformSupport();
        this.footprintRectangle = new Rectangle2D.Float((float)e.getPoint().x - (float)(this.pickSize / 2), (float)e.getPoint().y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        vv.addPostRenderPaintable(this.pickFootprintPaintable);
        vv.repaint();
        Point2D layoutPoint = transformSupport.inverseTransform(vv, this.down);
        boolean somethingSelected = false;
        if (e.getModifiersEx() == this.singleSelectionMask) {
            somethingSelected = this.singleEdgeSelection(e, layoutPoint, false);
        } else if (e.getModifiersEx() == this.toggleSingleSelectionMask) {
            somethingSelected = this.singleEdgeSelection(e, layoutPoint, true);
        } else {
            this.down = null;
        }
        if (somethingSelected) {
            e.consume();
        }
    }

    protected boolean singleEdgeSelection(MouseEvent e, Point2D layoutPoint, boolean addToSelection) {
        VisualizationServer vv = (VisualizationServer)e.getSource();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        MutableSelectedState selectedEdgeState = vv.getSelectedEdgeState();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Object edge = null;
        edge = pickSupport.getEdge(layoutModel, layoutPoint.getX(), layoutPoint.getY());
        if (edge != null) {
            log.trace("mousePressed set the edge to {}", edge);
            if (selectedEdgeState.isSelected(edge)) {
                if (!addToSelection) {
                    selectedEdgeState.deselect(edge);
                } else {
                    selectedEdgeState.select(edge);
                }
                e.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.trace("mouseReleased in {}", (Object)this.getClass().getName());
        Point out = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        this.edge = null;
        vv.removePostRenderPaintable(this.pickFootprintPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    protected Point2D inverseTransform(VisualizationViewer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.inverseTransform(p);
    }

    protected Shape transform(VisualizationViewer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.transform(shape);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    static {
        PropertyLoader.load();
    }

    class FootprintPaintable
    implements VisualizationServer.Paintable {
        FootprintPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(EdgeSelectingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(EdgeSelectingGraphMousePlugin.this.footprintRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

