/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.BoundImportForwarderRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BoundImportDescriptor
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_BOUND_IMPORT_DESCRIPTOR";
    public static final int IMAGE_SIZEOF_BOUND_IMPORT_DESCRIPTOR = 8;
    private String moduleName;
    private int timeDateStamp;
    private short offsetModuleName;
    private short numberOfModuleForwarderRefs;
    private List<BoundImportForwarderRef> forwarders = new ArrayList<BoundImportForwarderRef>();

    BoundImportDescriptor(BinaryReader reader, int readerIndex, int biddIndex) throws IOException {
        this.timeDateStamp = reader.readInt(readerIndex);
        this.offsetModuleName = reader.readShort(readerIndex += 4);
        this.numberOfModuleForwarderRefs = reader.readShort(readerIndex += 2);
        readerIndex += 2;
        if (this.offsetModuleName < 0) {
            Msg.error((Object)this, (Object)("Invalid offsetModuleName " + this.offsetModuleName));
            return;
        }
        this.moduleName = reader.readAsciiString(biddIndex + this.offsetModuleName);
        for (int i = 0; i < this.numberOfModuleForwarderRefs; ++i) {
            this.forwarders.add(new BoundImportForwarderRef(reader, readerIndex, biddIndex));
            readerIndex += 8;
        }
    }

    BoundImportDescriptor() {
    }

    public BoundImportDescriptor(String name, int timeDateStamp) {
        this.moduleName = name;
        this.timeDateStamp = timeDateStamp;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public short getOffsetModuleName() {
        return this.offsetModuleName;
    }

    void setOffsetModuleName(short offset) {
        this.offsetModuleName = offset;
    }

    public short getNumberOfModuleForwarderRefs() {
        return this.numberOfModuleForwarderRefs;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public BoundImportForwarderRef getBoundImportForwarderRef(int index) {
        if (index >= this.forwarders.size()) {
            return null;
        }
        return this.forwarders.get(index);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TimeStamp:" + Integer.toHexString(this.timeDateStamp) + ",");
        buffer.append("OffsetModuleName:" + Integer.toHexString(Short.toUnsignedInt(this.offsetModuleName)) + "[" + this.moduleName + "],");
        buffer.append("NumberOfModuleForwarderRefs:" + Integer.toHexString(Short.toUnsignedInt(this.numberOfModuleForwarderRefs)));
        buffer.append("\n");
        for (int i = 0; i < this.forwarders.size(); ++i) {
            BoundImportForwarderRef ref = this.forwarders.get(i);
            buffer.append("\tTimeStamp:" + Integer.toHexString(ref.getTimeDateStamp()) + ",");
            buffer.append("\tOffsetModuleName:" + Integer.toHexString(Short.toUnsignedInt(ref.getOffsetModuleName())) + "[" + ref.getModuleName() + "],");
            buffer.append("\tReserved:" + Integer.toHexString(Short.toUnsignedInt(ref.getReserved())));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType("IMAGE_BOUND_IMPORT_DESCRIPTOR_" + this.forwarders.size(), 0);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "OffsetModuleName", null);
        struct.add(WORD, "NumberOfModuleForwarderRefs", null);
        for (int i = 0; i < this.forwarders.size(); ++i) {
            BoundImportForwarderRef ref = this.forwarders.get(i);
            struct.add(ref.toDataType());
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[8 + this.numberOfModuleForwarderRefs * 8];
        int pos = 0;
        dc.getBytes(this.timeDateStamp, bytes, pos);
        dc.getBytes(this.offsetModuleName, bytes, pos += 4);
        dc.getBytes(this.numberOfModuleForwarderRefs, bytes, pos += 2);
        pos += 2;
        for (int i = 0; i < this.numberOfModuleForwarderRefs; ++i) {
            byte[] refBytes = this.forwarders.get(i).toBytes(dc);
            System.arraycopy(refBytes, 0, bytes, pos, refBytes.length);
            pos += refBytes.length;
        }
        return bytes;
    }
}

