/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.DropDownSelectionChoiceListener;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.DropDownWindowVisibilityListener;
import docking.widgets.GComponent;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.list.GList;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class DropDownTextField<T>
extends JTextField
implements GComponent {
    private static final int DEFAULT_MAX_UPDATE_DELAY = 2000;
    private static final int MIN_HEIGHT = 300;
    private static final int MIN_WIDTH = 200;
    protected static final Color PREVIEW_WINDOW_BGCOLOR = GThemeDefaults.Colors.Tooltips.BACKGROUND;
    protected static final Color PREVIEW_WINDOW_FGCOLOR = GThemeDefaults.Colors.Tooltips.FOREGROUND;
    private JWindow toolTipWindow;
    private JWindow matchingWindow;
    private DropDownWindowVisibilityListener<T> windowVisibilityListener = new DropDownWindowVisibilityListener();
    private GDHtmlLabel previewLabel;
    protected DropDownList list = new DropDownList();
    private WeakSet<DropDownSelectionChoiceListener<T>> choiceListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private Collection<CellEditorListener> cellEditorListeners = new HashSet<CellEditorListener>();
    private DocumentListener documentListener = new UpdateDocumentListener();
    private CaretListener caretListener = new UpdateCaretListener();
    private InternalKeyListener keyListener = new InternalKeyListener();
    private WindowComponentListener parentWindowListener = new WindowComponentListener();
    private T selectedValue;
    private int matchingWindowHeight = 300;
    private Point lastLocation;
    protected final DropDownTextFieldDataModel<T> dataModel;
    protected boolean internallyDrivenUpdate;
    private boolean consumeEnterKeyPress = true;
    private boolean ignoreEnterKeyPress = false;
    private boolean ignoreCaretChanges;
    private boolean showMachingListOnEmptyText;
    private String pendingTextUpdate;
    private SwingUpdateManager updateManager;
    private String currentMatchingText;

    public DropDownTextField(DropDownTextFieldDataModel<T> dataModel) {
        this(dataModel, 350);
    }

    public DropDownTextField(DropDownTextFieldDataModel<T> dataModel, int updateMinDelay) {
        super(30);
        this.dataModel = dataModel;
        this.init(updateMinDelay);
    }

    private void init(int updateMinDelay) {
        this.updateManager = new SwingUpdateManager(updateMinDelay, 2000, "Drop Down Selection Text Field Update Manager", () -> {
            if (this.pendingTextUpdate == null) {
                return;
            }
            this.doUpdateDisplayContents(this.pendingTextUpdate);
            this.pendingTextUpdate = null;
        });
        this.addFocusListener(new HideWindowFocusListener());
        this.addKeyListener(this.keyListener);
        this.setPreviewPaneAttributes();
        this.initDataList();
    }

    protected ListSelectionModel createListSelectionModel() {
        return new NoSelectionAllowedListSelectionModel();
    }

    protected void setPreviewPaneAttributes() {
        this.previewLabel = new GDHtmlLabel();
        this.previewLabel.setOpaque(true);
        this.previewLabel.setBackground(PREVIEW_WINDOW_BGCOLOR);
        this.previewLabel.setForeground(PREVIEW_WINDOW_FGCOLOR);
        this.previewLabel.setVerticalAlignment(1);
        this.previewLabel.setFocusable(false);
    }

    protected void setSelectedItems() {
        if (this.selectedValue != null) {
            this.list.setSelectedValue(this.selectedValue, true);
        }
    }

    protected ListSelectionListener getPreviewListener() {
        return new PreviewListener();
    }

    protected JComponent getPreviewPaneComponent() {
        return this.previewLabel;
    }

    private void validateChosenItemAgainstText(boolean isListShowing) {
        if (this.selectedValue == null) {
            return;
        }
        String selectedValueText = this.dataModel.getDisplayText(this.selectedValue);
        String textFieldText = this.getText();
        if (textFieldText == null || textFieldText.isEmpty()) {
            return;
        }
        if (!selectedValueText.equals(textFieldText) && !textFieldText.startsWith(selectedValueText)) {
            this.selectedValue = null;
        }
    }

    private void initDataList() {
        this.list.setCellRenderer(this.dataModel.getListRenderer());
        this.list.addKeyListener(this.keyListener);
        this.list.setFocusable(false);
        this.list.setSelectionModel(this.createListSelectionModel());
        this.list.addMouseListener(new ListSelectionMouseListener());
        this.list.addListSelectionListener(this.getPreviewListener());
    }

    private void addUpdateListeners() {
        this.removeUpdateListeners();
        this.addCaretListener(this.caretListener);
        this.getDocument().addDocumentListener(this.documentListener);
    }

    private void removeUpdateListeners() {
        this.removeCaretListener(this.caretListener);
        this.getDocument().removeDocumentListener(this.documentListener);
    }

    @Override
    public void setText(String text) {
        this.hideMatchingWindow();
        this.matchingWindow = null;
        this.removeUpdateListeners();
        super.setText(text);
        this.selectAll();
    }

    protected void setTextWithoutClosingCompletionWindow(String text) {
        super.setText(text);
    }

    private void updateDisplayLocation(boolean hasMatches) {
        if (!hasMatches) {
            this.hideMatchingWindow();
            return;
        }
        if (this.isShowing()) {
            this.updateWindowLocation();
            this.showMatchingWindow();
            JComponent previewComponent = this.getPreviewPaneComponent();
            previewComponent.setBackground(PREVIEW_WINDOW_BGCOLOR);
            previewComponent.setForeground(PREVIEW_WINDOW_FGCOLOR);
            this.toolTipWindow.setVisible(this.hasPreview());
        }
    }

    protected boolean hasPreview() {
        return !StringUtils.isBlank((CharSequence)this.previewLabel.getText());
    }

    private void updateWindowLocation() {
        Point location = this.getLocationOnScreen();
        if (location.equals(this.lastLocation)) {
            return;
        }
        this.lastLocation = new Point(location.x, location.y + this.getHeight());
        Rectangle newBounds = new Rectangle(this.lastLocation.x, this.lastLocation.y, Math.max(200, this.getWidth()), this.matchingWindowHeight);
        this.list.setFixedCellWidth(newBounds.width - 20);
        this.getMatchingWindow().setBounds(newBounds);
        this.toolTipWindow.setBounds(newBounds.x + newBounds.width, newBounds.y, newBounds.width, newBounds.height);
    }

    private void updateDisplayContents(String userText) {
        this.pendingTextUpdate = userText;
        this.updateManager.updateLater();
    }

    private void maybeUpdateDisplayContents(String userText) {
        if (SystemUtilities.isEqual((Object)userText, (Object)this.pendingTextUpdate)) {
            return;
        }
        this.updateDisplayContents(userText);
    }

    private void doUpdateDisplayContents(String userText) {
        if (this.internallyDrivenUpdate) {
            this.internallyDrivenUpdate = false;
            return;
        }
        this.currentMatchingText = userText;
        final List<T> data = this.getMatchingData(userText);
        this.list.setModel(new AbstractListModel<T>(){

            @Override
            public int getSize() {
                return data.size();
            }

            @Override
            public T getElementAt(int i) {
                return data.get(i);
            }
        });
        if (data.isEmpty()) {
            this.updateDisplayLocation(false);
            return;
        }
        this.setSelectedItems();
        int index = this.dataModel.getIndexOfFirstMatchingEntry(data, userText);
        if (index < 0) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        } else {
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
        this.updateDisplayLocation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getMatchingData(String searchText) {
        if (searchText == null) {
            return Collections.emptyList();
        }
        if (searchText.isEmpty() && !this.showMachingListOnEmptyText) {
            return Collections.emptyList();
        }
        Cursor previousCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            List<T> list = this.dataModel.getMatchingData(searchText);
            return list;
        }
        finally {
            this.setCursor(previousCursor);
        }
    }

    public boolean isMatchingListShowing() {
        if (this.matchingWindow == null) {
            return false;
        }
        return this.matchingWindow.isShowing();
    }

    public void showMatchingList() {
        boolean restore = this.showMachingListOnEmptyText;
        try {
            this.showMachingListOnEmptyText = true;
            this.pendingTextUpdate = this.pendingTextUpdate != null ? this.pendingTextUpdate : this.getText();
            this.updateManager.updateNow();
        }
        finally {
            this.showMachingListOnEmptyText = restore;
        }
    }

    public void setConsumeEnterKeyPress(boolean consume) {
        this.consumeEnterKeyPress = consume;
    }

    public void setIgnoreEnterKeyPress(boolean ignore) {
        this.ignoreEnterKeyPress = ignore;
    }

    public void setShowMatchingListOnEmptyText(boolean show) {
        this.showMachingListOnEmptyText = show;
    }

    public void setMatchingWindowHeight(int height) {
        this.matchingWindowHeight = height;
        if (this.matchingWindow == null) {
            return;
        }
        this.updateDisplayLocation(this.getMatchingWindow().isShowing());
    }

    public void addDropDownSelectionChoiceListener(DropDownSelectionChoiceListener<T> listener) {
        this.choiceListeners.add(listener);
    }

    public void addCellEditorListener(CellEditorListener listener) {
        if (this.cellEditorListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener has already been added: " + String.valueOf(listener));
        }
        this.cellEditorListeners.add(listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.cellEditorListeners.remove(listener);
    }

    private void fireUserChoiceMade(T selectedItem) {
        for (DropDownSelectionChoiceListener listener : this.choiceListeners) {
            listener.selectionChanged(selectedItem);
        }
    }

    private void fireEditingCancelled() {
        this.updateManager.stop();
        this.hideMatchingWindow();
        this.storeSelectedValue(null);
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.cellEditorListeners) {
            listener.editingCanceled(event);
        }
    }

    private void fireEditingStopped() {
        this.updateManager.stop();
        this.hideMatchingWindow();
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.cellEditorListeners) {
            listener.editingStopped(event);
        }
    }

    private void createMatchingWindow() {
        Window parentWindow = WindowUtilities.windowForComponent((Component)this);
        if (parentWindow == null) {
            return;
        }
        parentWindow.removeComponentListener(this.parentWindowListener);
        parentWindow.addComponentListener(this.parentWindowListener);
        this.matchingWindow = new JWindow(parentWindow);
        this.matchingWindow.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createBevelBorder(0, (Color)new GColor("color.border.bevel.highlight"), (Color)new GColor("color.border.bevel.shadow")));
        scrollPane.setFocusable(false);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().add(this.list);
        this.matchingWindow.getContentPane().add(scrollPane);
        this.matchingWindow.setSize(200, this.matchingWindowHeight);
        this.addUpdateListeners();
        this.createToolTipWindow(parentWindow);
    }

    private JWindow getMatchingWindow() {
        if (this.matchingWindow == null) {
            this.createMatchingWindow();
            return this.matchingWindow;
        }
        Window currentParentWindow = WindowUtilities.windowForComponent((Component)this);
        if (currentParentWindow != this.matchingWindow.getParent()) {
            this.createMatchingWindow();
        }
        return this.matchingWindow;
    }

    private void createToolTipWindow(Window parent) {
        this.toolTipWindow = new JWindow(parent);
        this.toolTipWindow.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(0));
        scrollPane.setFocusable(false);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        scrollPane.getViewport().add(this.getPreviewPaneComponent());
        this.toolTipWindow.getContentPane().add(scrollPane);
    }

    private void storeSelectedValue(T newValue) {
        this.selectedValue = newValue;
    }

    protected void setTextFromList() {
        Object selectedItem = this.list.getSelectedValue();
        if (selectedItem != null) {
            this.storeSelectedValue(selectedItem);
            this.setText(this.dataModel.getDisplayText(this.selectedValue));
            this.hideMatchingWindow();
            this.fireUserChoiceMade(selectedItem);
        }
    }

    private void setTextFromDoubleClick(MouseEvent event) {
        int row = this.list.locationToIndex(event.getPoint());
        Object clickedItem = this.list.getModel().getElementAt(row);
        this.storeSelectedValue(clickedItem);
        this.setText(this.dataModel.getDisplayText(this.selectedValue));
        this.hideMatchingWindow();
        this.fireUserChoiceMade(clickedItem);
    }

    private void setTextFromListOnEnterPress() {
        Object selectedItem = this.list.getSelectedValue();
        if (selectedItem == null) {
            return;
        }
        String textFieldText = this.getText();
        if (!this.shouldReplaceTextFieldTextWithSelectedItem(textFieldText, selectedItem)) {
            return;
        }
        this.setTextFromList();
    }

    protected boolean shouldReplaceTextFieldTextWithSelectedItem(String textFieldText, T selectedItem) {
        String listItemText = this.dataModel.getDisplayText(selectedItem);
        return StringUtilities.startsWithIgnoreCase((String)listItemText, (String)textFieldText);
    }

    public T getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(T value) {
        this.storeSelectedValue(value);
        if (value != null) {
            this.setText(this.dataModel.getDisplayText(value));
            this.setToolTipText(this.dataModel.getDescription(value));
        } else {
            this.setText("");
            this.setToolTipText("");
        }
    }

    public void closeDropDownWindow() {
        this.hideMatchingWindow();
    }

    private void showMatchingWindow() {
        JWindow w = this.getMatchingWindow();
        w.setVisible(true);
        this.windowVisibilityListener.windowShown(this);
    }

    protected void hideMatchingWindow() {
        if (this.matchingWindow != null && this.matchingWindow.isShowing()) {
            this.matchingWindow.setVisible(false);
            this.windowVisibilityListener.windowHidden(this);
            this.toolTipWindow.setVisible(false);
            this.list.clearSelection();
        }
    }

    JList<T> getJList() {
        return this.list;
    }

    JWindow getActiveMatchingWindow() {
        return this.matchingWindow;
    }

    void setMatchingWindowVisibilityListener(DropDownWindowVisibilityListener<T> l) {
        this.windowVisibilityListener = Objects.requireNonNull(l);
    }

    private void handleArrowKey(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (!this.getMatchingWindow().isShowing()) {
            this.updateDisplayContents(this.getText());
            event.consume();
        } else {
            if (keyCode == 38 || keyCode == 224) {
                this.decrementListSelection();
            } else {
                this.incrementListSelection();
            }
            event.consume();
            this.setTextFromSelectedListItemAndKeepMatchingWindowOpen();
        }
    }

    private void incrementListSelection() {
        int index = this.list.getSelectedIndex();
        int listSize = this.list.getModel().getSize();
        index = index < 0 ? 0 : (index == listSize - 1 ? 0 : ++index);
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    private void decrementListSelection() {
        int index = this.list.getSelectedIndex();
        int listSize = this.list.getModel().getSize();
        index = index < 0 ? 0 : (index == 0 ? listSize - 1 : --index);
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    protected void setTextFromSelectedListItemAndKeepMatchingWindowOpen() {
        Object selectedItem = this.list.getSelectedValue();
        if (selectedItem == null) {
            return;
        }
        this.internallyDrivenUpdate = true;
        this.storeSelectedValue(selectedItem);
        this.setTextWithoutClosingCompletionWindow(this.dataModel.getDisplayText(this.selectedValue));
        this.fireUserChoiceMade(selectedItem);
    }

    protected class DropDownList
    extends GList<T> {
        protected DropDownList() {
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            this.updateCellDimensions(f);
        }

        private void updateCellDimensions(Font font) {
            if (font == null || DropDownTextField.this.list == null) {
                return;
            }
            FontMetrics fontMetrics = DropDownTextField.this.list.getFontMetrics(font);
            int padding = 2;
            int lineHeight = fontMetrics.getHeight() + padding;
            int iconAndPaddingHeight = 16 + padding;
            int cellHeight = Math.max(lineHeight, iconAndPaddingHeight);
            DropDownTextField.this.list.setFixedCellHeight(cellHeight);
            DropDownTextField.this.list.setFixedCellWidth(180);
        }
    }

    private class UpdateDocumentListener
    implements DocumentListener {
        private UpdateDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            DropDownTextField.this.updateDisplayContents(DropDownTextField.this.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DropDownTextField.this.updateDisplayContents(DropDownTextField.this.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DropDownTextField.this.updateDisplayContents(DropDownTextField.this.getText());
        }
    }

    private class UpdateCaretListener
    implements CaretListener {
        private UpdateCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent event) {
            if (DropDownTextField.this.ignoreCaretChanges) {
                return;
            }
            String text = DropDownTextField.this.getText();
            if (text == null || text.isEmpty()) {
                return;
            }
            String textToCaret = text.substring(0, event.getDot());
            if (textToCaret.equals(DropDownTextField.this.currentMatchingText)) {
                return;
            }
            DropDownTextField.this.maybeUpdateDisplayContents(textToCaret);
        }
    }

    private class InternalKeyListener
    extends KeyAdapter {
        private InternalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            DropDownTextField.this.getMatchingWindow();
            int keyCode = event.getKeyCode();
            if (CollectionUtils.isOneOf((Object)keyCode, (Object[])new Integer[]{38, 40, 224, 225})) {
                DropDownTextField.this.handleArrowKey(event);
            } else if (keyCode == 10) {
                this.handleEnterKey(event);
            } else if (keyCode == 27) {
                this.handleEscapeKey(event);
            }
            DropDownTextField.this.setToolTipText(DropDownTextField.this.getToolTipText());
        }

        private void handleEscapeKey(KeyEvent event) {
            if (DropDownTextField.this.getMatchingWindow().isShowing()) {
                DropDownTextField.this.hideMatchingWindow();
            } else {
                DropDownTextField.this.fireEditingCancelled();
            }
            event.consume();
        }

        private void handleEnterKey(KeyEvent event) {
            if (DropDownTextField.this.ignoreEnterKeyPress) {
                return;
            }
            boolean listShowing = DropDownTextField.this.isMatchingListShowing();
            if (DropDownTextField.this.consumeEnterKeyPress) {
                if (listShowing) {
                    DropDownTextField.this.setTextFromListOnEnterPress();
                    DropDownTextField.this.validateChosenItemAgainstText(true);
                    event.consume();
                    return;
                }
                DropDownTextField.this.validateChosenItemAgainstText(false);
                DropDownTextField.this.fireEditingStopped();
                return;
            }
            DropDownTextField.this.setTextFromListOnEnterPress();
            DropDownTextField.this.validateChosenItemAgainstText(listShowing);
            DropDownTextField.this.fireEditingStopped();
        }
    }

    private class WindowComponentListener
    extends ComponentAdapter {
        private WindowComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent event) {
            DropDownTextField.this.hideMatchingWindow();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            JWindow window = DropDownTextField.this.getMatchingWindow();
            if (window == null) {
                return;
            }
            DropDownTextField.this.updateDisplayLocation(window.isShowing());
        }

        @Override
        public void componentResized(ComponentEvent event) {
            JWindow window = DropDownTextField.this.getMatchingWindow();
            if (window == null) {
                return;
            }
            DropDownTextField.this.updateDisplayLocation(window.isShowing());
        }
    }

    private class HideWindowFocusListener
    extends FocusAdapter {
        private HideWindowFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Component newFocusOwner = event.getOppositeComponent();
            if (CollectionUtils.isOneOf((Object)newFocusOwner, (Object[])new Component[]{DropDownTextField.this.list, DropDownTextField.this.matchingWindow, DropDownTextField.this.toolTipWindow})) {
                return;
            }
            DropDownTextField.this.ignoreCaretChanges = true;
            DropDownTextField.this.hideMatchingWindow();
        }

        @Override
        public void focusGained(FocusEvent e) {
            DropDownTextField.this.ignoreCaretChanges = false;
        }
    }

    private class NoSelectionAllowedListSelectionModel
    extends DefaultListSelectionModel {
        private NoSelectionAllowedListSelectionModel() {
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public void addListSelectionListener(ListSelectionListener l) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener l) {
        }

        @Override
        public void setLeadAnchorNotificationEnabled(boolean flag) {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
        }

        @Override
        public void setValueIsAdjusting(boolean isAdjusting) {
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
        }
    }

    class PreviewListener
    implements ListSelectionListener {
        PreviewListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object value = DropDownTextField.this.list.getSelectedValue();
            String text = "";
            if (value != null) {
                text = DropDownTextField.this.dataModel.getDescription(value);
            }
            DropDownTextField.this.previewLabel.setText(text);
        }
    }

    private class ListSelectionMouseListener
    extends MouseAdapter {
        private ListSelectionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 1) {
                DropDownTextField.this.setTextFromSelectedListItemAndKeepMatchingWindowOpen();
            } else if (event.getClickCount() > 1) {
                if (this.selctionIsAllowed()) {
                    DropDownTextField.this.setTextFromList();
                } else {
                    DropDownTextField.this.setTextFromDoubleClick(event);
                }
            }
        }

        private boolean selctionIsAllowed() {
            ListSelectionModel model = DropDownTextField.this.list.getSelectionModel();
            return !(model instanceof NoSelectionAllowedListSelectionModel);
        }
    }
}

