---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitHub OAuth Access Token'
---

## Description

The response body contains content that matches the pattern of a GitHub OAuth Access Token was identified. Unlike a traditional OAuth token, user access tokens do not use scopes. Instead, it uses fine-grained permissions. A user access token only has permissions that both the user and the app have. If a malicious actor gains access to the token and the app was granted permission to write the contents of a repository, but the user can only read the contents, then the user access token can only read the contents.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). For more information, please see [GitHubs documentation to revoke an OAuth access tokens](https://docs.github.com/en/rest/apps/oauth-applications?apiVersion=2022-11-28#delete-an-app-token). Also note, GitHub Apps are preferred over OAuth apps, please see [GitHubs documentation for more details](https://docs.github.com/en/apps/oauth-apps/building-oauth-apps/differences-between-github-apps-and-oauth-apps).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.53 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
