/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandBatchQuickFix;
import com.intellij.modcommand.ModTemplateBuilder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectRenderingLanguage;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaReader2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddMissingPropertyFix
extends ModCommandBatchQuickFix {
    private final JsonValidationError.MissingMultiplePropsIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public AddMissingPropertyFix(JsonValidationError.MissingMultiplePropsIssueData data, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"add.missing.properties", (Object[])new Object[0]);
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = JsonBundle.message((String)"add.missing.0", (Object[])new Object[]{this.myData.getMessage(true)});
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull List<ProblemDescriptor> descriptors) {
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(3);
        }
        if (descriptors.isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AddMissingPropertyFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptors.get(0)), updater -> {
            if (descriptors.size() == 1) {
                TextRange range;
                AddMissingPropertyFix fix;
                ProblemDescriptor descriptor = (ProblemDescriptor)descriptors.get(0);
                QuickFix[] fixes = descriptor.getFixes();
                AddMissingPropertyFix addMissingPropertyFix = fix = fixes == null ? this : AddMissingPropertyFix.getWorkingQuickFix(fixes);
                if (fix == null) {
                    return;
                }
                PsiElement elementCopy = updater.getWritable(descriptor.getPsiElement());
                PsiFile file = elementCopy.getContainingFile();
                CodeStyleManager.getInstance((Project)project).reformatText(file, 0, file.getTextLength());
                Ref newElementRef = Ref.create();
                fix.performFixInner(elementCopy, (Ref<PsiElement>)newElementRef);
                PsiElement newElement = (PsiElement)newElementRef.get();
                if (newElement == null) {
                    return;
                }
                JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(newElement);
                if (walker == null) {
                    return;
                }
                Collection<JsonValueAdapter> values = Objects.requireNonNull(walker.getParentPropertyAdapter(newElement)).getValues();
                PsiElement value = values.size() == 1 ? values.iterator().next().getDelegate() : null;
                if (value == null || value.getText().isBlank()) {
                    updater.moveCaretTo(newElement.getTextRange().getEndOffset());
                    return;
                }
                String text = value.getText();
                boolean isEmptyArray = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"[]");
                boolean isEmptyObject = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"{}");
                boolean goInside = isEmptyArray || isEmptyObject || StringUtil.isQuotedString((String)text);
                TextRange textRange = range = goInside ? TextRange.create((int)1, (int)(text.length() - 1)) : TextRange.create((int)0, (int)text.length());
                MacroCallNode expr = fix.myData.myMissingPropertyIssues.iterator().next().enumItemsCount > 1 || isEmptyObject ? new MacroCallNode((Macro)new CompleteMacro()) : (isEmptyArray ? new EmptyNode() : new ConstantNode(goInside ? StringUtil.unquoteString((String)text) : text));
                updater.moveCaretTo(newElement.getTextRange().getStartOffset());
                ModTemplateBuilder builder = updater.templateBuilder();
                builder.field(value, range, "VALUE", (Expression)expr);
                builder.finishAt(newElement.getTextRange().getEndOffset());
            } else {
                for (ProblemDescriptor d : descriptors) {
                    AddMissingPropertyFix fix;
                    QuickFix[] fixes = d.getFixes();
                    AddMissingPropertyFix addMissingPropertyFix = fix = fixes == null ? this : AddMissingPropertyFix.getWorkingQuickFix(fixes);
                    if (fix == null) continue;
                    PsiElement elementCopy = updater.getWritable(d.getPsiElement());
                    fix.performFixInner(elementCopy, (Ref<PsiElement>)Ref.create());
                }
            }
        });
        if (modCommand == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(5);
        }
        return modCommand;
    }

    @Nullable
    public PsiElement performFix(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement element = node instanceof PsiFile ? node.getFirstChild() : node;
        Ref newElementRef = Ref.create(null);
        WriteAction.run(() -> this.performFixInner(element, (Ref<PsiElement>)newElementRef));
        return (PsiElement)newElementRef.get();
    }

    public void performFixInner(PsiElement element, Ref<PsiElement> newElementRef) {
        PsiElement context;
        boolean isSingle = this.myData.myMissingPropertyIssues.size() == 1;
        PsiElement psiElement = context = element instanceof PsiFile ? element.getFirstChild() : element;
        if (context == null) {
            return;
        }
        PsiElement processedElement = context;
        List reverseOrder = ContainerUtil.reverse(new ArrayList<JsonValidationError.MissingPropertyIssueData>(this.myData.myMissingPropertyIssues));
        for (JsonValidationError.MissingPropertyIssueData issue : reverseOrder) {
            PsiElement adjusted;
            Object defaultValueObject = issue.defaultValue;
            String defaultValue = this.formatDefaultValue(defaultValueObject, context.getLanguage());
            PsiElement property = this.myQuickFixAdapter.createProperty(issue.propertyName, defaultValue == null ? this.myQuickFixAdapter.getDefaultValueFromType(issue.propertyType) : defaultValue, processedElement.getProject());
            processedElement = adjusted = this.myQuickFixAdapter.addProperty(processedElement, property);
            if (!isSingle) continue;
            newElementRef.set((Object)adjusted);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public String formatDefaultValue(@Nullable Object defaultValueObject, @NotNull Language targetLanguage) {
        if (targetLanguage == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(6);
        }
        if (defaultValueObject instanceof JsonSchemaObject) {
            JsonSchemaObject schemaObject = (JsonSchemaObject)defaultValueObject;
            JsonSchemaObjectRenderingLanguage renderingLanguage = targetLanguage.is((Language)JsonLanguage.INSTANCE) ? JsonSchemaObjectRenderingLanguage.JSON : JsonSchemaObjectRenderingLanguage.YAML;
            return JsonSchemaReader2.renderSchemaNode(schemaObject, renderingLanguage);
        }
        if (defaultValueObject instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)defaultValueObject;
            return AddMissingPropertyFix.convertToYamlIfNeeded(targetLanguage, jsonNode);
        }
        if (defaultValueObject instanceof String) {
            return StringUtil.wrapWithDoubleQuote((String)defaultValueObject.toString());
        }
        if (defaultValueObject instanceof Boolean) {
            return Boolean.toString((Boolean)defaultValueObject);
        }
        if (defaultValueObject instanceof Number) {
            return defaultValueObject.toString();
        }
        if (defaultValueObject instanceof PsiElement) {
            return ((PsiElement)defaultValueObject).getText();
        }
        return null;
    }

    @Nullable
    private static String convertToYamlIfNeeded(@NotNull Language language, JsonNode jsonNode) {
        if (language == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(7);
        }
        Object jacksonFactory = language.is((Language)JsonLanguage.INSTANCE) ? new JsonFactory() : YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).build();
        try {
            String exampleInTargetLanguage = new ObjectMapper(jacksonFactory).writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            return StringUtil.trimEnd((String)exampleInTargetLanguage, (String)"\n");
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    @Nullable
    private static AddMissingPropertyFix getWorkingQuickFix(QuickFix @NotNull [] fixes) {
        if (fixes == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(8);
        }
        for (QuickFix fix : fixes) {
            if (!(fix instanceof AddMissingPropertyFix)) continue;
            return (AddMissingPropertyFix)fix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLanguage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatDefaultValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToYamlIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

