/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicMethodDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class DynamicMethodFix
implements IntentionAction,
LowPriorityAction {
    private final GrReferenceExpression myReferenceExpression;
    private final String mySignature;

    public DynamicMethodFix(GrReferenceExpression referenceExpression, PsiType[] argumentTypes) {
        this.myReferenceExpression = referenceExpression;
        this.mySignature = this.calcSignature(argumentTypes);
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.method.0", this.mySignature);
        if (string == null) {
            DynamicMethodFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private String calcSignature(PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder().append(this.myReferenceExpression.getReferenceName());
        builder.append("(");
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            PsiType type = argTypes[i2];
            if (i2 > 0) {
                builder.append(", ");
            }
            if (type == null) {
                builder.append("Object");
                continue;
            }
            builder.append(type.getPresentableText());
        }
        builder.append(")");
        return builder.toString();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            DynamicMethodFix.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DynamicMethodFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            DynamicMethodFix.$$$reportNull$$$0(3);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, "Dynamic namespace", "", "Object " + this.myReferenceExpression.getReferenceName() + "()");
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            DynamicMethodFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            DynamicMethodFix.$$$reportNull$$$0(5);
        }
        return this.myReferenceExpression.isValid() && !PsiUtil.isInStaticCompilationContext(this.myReferenceExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            DynamicMethodFix.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            DynamicManager.getInstance(project).addMethod(QuickfixUtil.createSettings(this.myReferenceExpression));
            return;
        }
        DynamicMethodDialog dialog = new DynamicMethodDialog(this.myReferenceExpression);
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

