/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/settingsSync/core/statistics/SettingsSyncStateStatistics;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "SETTINGS_SYNC_ENABLED_STATE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DISABLED_CATEGORIES", "Lcom/intellij/openapi/components/SettingsCategory;", "BUNDLED_PLUGINS_DISABLED", "EDITOR_FONT_STATE", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getGroup", "intellij.settingsSync.core"})
public final class SettingsSyncStateStatistics
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("settings.sync.state", 4, null, 4, null);
    @NotNull
    private final EventId1<Boolean> SETTINGS_SYNC_ENABLED_STATE = this.GROUP.registerEvent("general.state", (EventField)EventFields.Boolean((String)"enabled"));
    @NotNull
    private final EventId1<SettingsCategory> DISABLED_CATEGORIES = this.GROUP.registerEvent("disabled.categories", (EventField)EventFields.Enum$default((String)"category", SettingsCategory.class, null, (int)4, null));
    @NotNull
    private final EventId1<Boolean> BUNDLED_PLUGINS_DISABLED = this.GROUP.registerEvent("disabled.bundled.plugins", (EventField)EventFields.Boolean((String)"disabled"));
    @NotNull
    private final EventId1<Boolean> EDITOR_FONT_STATE = this.GROUP.registerEvent("editor.font.state", (EventField)EventFields.Boolean((String)"enabled"));

    @NotNull
    public Set<MetricEvent> getMetrics() {
        SettingsSyncSettings settings = SettingsSyncSettings.Companion.getInstance();
        Set result2 = new LinkedHashSet();
        ((Collection)result2).add(this.SETTINGS_SYNC_ENABLED_STATE.metric((Object)settings.getSyncEnabled()));
        for (SettingsCategory disabledCategory : ((SettingsSyncSettings.State)settings.getState()).disabledCategories) {
            ((Collection)result2).add(this.DISABLED_CATEGORIES.metric((Object)disabledCategory));
        }
        Map<SettingsCategory, List<String>> disabledSubcategories = ((SettingsSyncSettings.State)settings.getState()).disabledSubcategories;
        Collection<String> collection = disabledSubcategories.get(SettingsCategory.PLUGINS);
        boolean bl = collection != null ? collection.contains("bundled") : false;
        if (bl) {
            ((Collection)result2).add(this.BUNDLED_PLUGINS_DISABLED.metric((Object)true));
        }
        collection = result2;
        List<String> list = disabledSubcategories.get(SettingsCategory.UI);
        collection.add((String)this.EDITOR_FONT_STATE.metric((Object)(list != null ? list.contains("editorFont") : false)));
        return result2;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

