/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.dictionary.HashSetDictionary;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/InMemoryDictionaryStorage;", "Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "()V", "dictionaries", "", "", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary;", "closeAll", "", "getDictionaryByName", "name", "updateDictionaryByName", "dictionary", "", "ap-validation"})
public final class InMemoryDictionaryStorage
implements DictionaryStorage {
    @NotNull
    private final Map<String, Dictionary> dictionaries = new LinkedHashMap();

    @Override
    @NotNull
    public Dictionary getDictionaryByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Dictionary dictionary = this.dictionaries.get(name);
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary " + name + " could not be found");
        }
        return dictionary;
    }

    @Override
    public void updateDictionaryByName(@NotNull String name, @NotNull byte[] dictionary) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        this.dictionaries.put(name, HashSetDictionary.Companion.create(dictionary));
    }

    @Override
    public void closeAll() {
        this.dictionaries.clear();
    }
}

