/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.lang.properties.structuralsearch.PropertiesMatchingStrategy;
import com.intellij.lang.properties.template.PropertiesContextType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class PropertiesStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    PropertiesStructuralSearchProfile() {
    }

    public Configuration @NotNull [] getPredefinedTemplates() {
        Configuration[] configurationArray = new Configuration[]{PropertiesStructuralSearchProfile.createConfiguration(PropertiesBundle.message((String)"predefined.configuration.duplicated.word.in.property.value", (Object[])new Object[0]), "Duplicated word", "'_key='value:.*\\b(\\w+)\\s+\\1\\b.*"), PropertiesStructuralSearchProfile.createConfiguration(PropertiesBundle.message((String)"predefined.configuration.double.single.quote.in.value.without.curly.brace", (Object[])new Object[0]), "Double ' without {", "'_key='value:[ regex( [^{]*''[^{]* ) ]")};
        if (configurationArray == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return configurationArray;
    }

    @NotNull
    private static Configuration createConfiguration(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name, @NotNull @NonNls String refName, @NotNull @NonNls String criteria) {
        if (name == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (refName == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        if (criteria == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        Configuration configuration = PredefinedConfigurationUtil.createConfiguration((String)name, (String)refName, (String)criteria, (String)PropertiesBundle.message((String)"properties.files.inspection.group.display.name", (Object[])new Object[0]), (LanguageFileType)PropertiesFileType.INSTANCE);
        if (configuration == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return configuration;
    }

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical) {
        PsiFile file;
        PsiElement child;
        if (text == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (contextInfo == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (language == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if ((child = (file = PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.properties", language, (CharSequence)text, physical, true)).getFirstChild()) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PropertiesStructuralSearchProfile.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        for (PsiElement patternElement = child.getFirstChild(); patternElement != null; patternElement = patternElement.getNextSibling()) {
            if (!(patternElement instanceof Property) && !(patternElement instanceof PsiComment)) continue;
            result.add((Object)patternElement);
        }
        PsiElement[] psiElementArray = (PsiElement[])result.toArray((Object[])PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    public void compile(PsiElement @NotNull [] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (elements == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (elements.length > 1) {
            throw new MalformedPatternException();
        }
        CompiledPattern pattern = globalVisitor.getContext().getPattern();
        for (PsiElement element : elements) {
            if (element instanceof PsiComment) {
                PsiComment comment = (PsiComment)element;
                String commentText = comment.getText();
                if (globalVisitor.hasFragments(commentText)) {
                    MatchingHandler handler = globalVisitor.processPatternStringWithFragments(commentText, GlobalCompilingVisitor.OccurenceKind.COMMENT);
                    if (handler != null) {
                        comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                    }
                } else {
                    globalVisitor.handle((PsiElement)comment);
                }
                pattern.getHandler(element).setFilter(e -> e instanceof PsiComment);
            } else if (element instanceof Property) {
                PsiElement lastChild;
                Property property = (Property)element;
                pattern.getHandler(element).setFilter(e -> e instanceof Property);
                PsiElement firstChild = property.getFirstChild();
                if (firstChild instanceof PropertyKeyImpl) {
                    globalVisitor.handle(firstChild);
                    pattern.getHandler(firstChild).setFilter(e -> e instanceof PropertyKeyImpl);
                }
                if ((lastChild = property.getLastChild()) instanceof PropertyValueImpl) {
                    String valueText = lastChild.getText();
                    MatchingHandler handler = globalVisitor.processPatternStringWithFragments(valueText, GlobalCompilingVisitor.OccurenceKind.TEXT);
                    if (handler != null) {
                        lastChild.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                    }
                    pattern.getHandler(firstChild).setFilter(e -> e instanceof PropertyValueImpl);
                }
            }
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(final @NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        return new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof Property) {
                    PsiElement value;
                    Property other = (Property)globalVisitor.getElement(Property.class);
                    PsiElement key = element.getFirstChild();
                    if (globalVisitor.setResult(globalVisitor.match(key, other.getFirstChild())) && (value = element.getLastChild()) instanceof PropertyValueImpl) {
                        PsiElement otherValue = other.getLastChild();
                        globalVisitor.setResult(globalVisitor.matchOptionally(value, (PsiElement)(otherValue instanceof PropertyValueImpl ? otherValue : null)));
                    }
                } else if (element instanceof PropertyKeyImpl) {
                    PropertyKeyImpl other = (PropertyKeyImpl)globalVisitor.getElement(PropertyKeyImpl.class);
                    MatchContext context = globalVisitor.getMatchContext();
                    MatchingHandler handler = context.getPattern().getHandler(element);
                    if (handler instanceof SubstitutionHandler) {
                        globalVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, context));
                    } else {
                        globalVisitor.setResult(globalVisitor.matchText(element, (PsiElement)other));
                    }
                } else if (element instanceof PropertyValueImpl) {
                    PropertyValueImpl other = (PropertyValueImpl)globalVisitor.getElement(PropertyValueImpl.class);
                    MatchContext context = globalVisitor.getMatchContext();
                    MatchingHandler handler = (MatchingHandler)element.getUserData(CompiledPattern.HANDLER_KEY);
                    if (handler instanceof LiteralWithSubstitutionHandler) {
                        globalVisitor.setResult(handler.match(element, (PsiElement)other, context));
                    } else if (handler instanceof SubstitutionHandler) {
                        globalVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, context));
                    } else {
                        globalVisitor.setResult(globalVisitor.matchText(element, (PsiElement)other));
                    }
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement other = globalVisitor.getElement();
                MatchingHandler handler = (MatchingHandler)comment.getUserData(CompiledPattern.HANDLER_KEY);
                globalVisitor.setResult(handler instanceof LiteralWithSubstitutionHandler ? handler.match((PsiElement)comment, other, globalVisitor.getMatchContext()) : globalVisitor.matchText((PsiElement)comment, other));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/properties/structuralsearch/PropertiesStructuralSearchProfile$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new CompiledPattern(this){
            {
                this.setStrategy(PropertiesMatchingStrategy.INSTANCE);
            }

            public String @NotNull [] getTypedVarPrefixes() {
                String[] stringArray = new String[]{PropertiesStructuralSearchProfile.TYPED_VAR_PREFIX};
                if (stringArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return stringArray;
            }

            public boolean isTypedVar(@NotNull String str) {
                if (str == null) {
                    2.$$$reportNull$$$0(1);
                }
                return str.startsWith(PropertiesStructuralSearchProfile.TYPED_VAR_PREFIX);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/properties/structuralsearch/PropertiesStructuralSearchProfile$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarPrefixes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/properties/structuralsearch/PropertiesStructuralSearchProfile$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isTypedVar";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        return language == PropertiesLanguage.INSTANCE;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return PropertiesContextType.class;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(16);
        }
        if (replaceOptions == null) {
            PropertiesStructuralSearchProfile.$$$reportNull$$$0(17);
        }
        return new DocumentBasedReplaceHandler(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/structuralsearch/PropertiesStructuralSearchProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "criteria";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/structuralsearch/PropertiesStructuralSearchProfile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

