/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RegistrationRequest {
    private final byte[] attestationObject;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final Set<String> transports;

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable Set<String> transports) {
        this.attestationObject = ArrayUtil.clone(attestationObject);
        this.clientDataJSON = ArrayUtil.clone(clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON) {
        this(attestationObject, clientDataJSON, clientExtensionsJSON, null);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable Set<String> transports) {
        this(attestationObject, clientDataJSON, null, transports);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON) {
        this(attestationObject, clientDataJSON, null, null);
    }

    @Nullable
    public byte[] getAttestationObject() {
        return ArrayUtil.clone(this.attestationObject);
    }

    @Nullable
    public byte[] getClientDataJSON() {
        return ArrayUtil.clone(this.clientDataJSON);
    }

    @Nullable
    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    @Nullable
    public Set<String> getTransports() {
        return this.transports;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationRequest that = (RegistrationRequest)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON, this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        return result;
    }

    public String toString() {
        return "RegistrationRequest{attestationObject=" + ArrayUtil.toHexString(this.attestationObject) + ", clientDataJSON=" + ArrayUtil.toHexString(this.clientDataJSON) + ", clientExtensionsJSON=" + this.clientExtensionsJSON + ", transports=" + String.valueOf(this.transports) + "}";
    }
}

