# -*- coding: binary -*-

# GitLab version mixin
module Msf::Exploit::Remote::HTTP::Gitlab::Version
  # Used to check if the version is correct: must contain at least one dot
  GITLAB_VERSION_PATTERN = '(\d+\.\d+(?:\.\d+)*)'.freeze
  # CSS-based filename fingerprinting
  GITLAB_CSS_PATTERN = '<link rel="stylesheet"(?: media="[a-z]+")? href="/assets/application-([a-z0-9]+)[.]css"'.freeze
  # Map of CSS filenames to gitlab versions
  GITLAB_CSS_MAP = {
    '3c4113c2c5509243fa5fe9efa3df9d2b61eecb3a70767c3caf1f15ca3efd0b84' => ['8.10.0-ee', '8.10.0-ee'],
    '4d43dfc52000c727bdfd2c0a77b6bb295ad4a4288ac946e12994775899406f8d' => ['8.10.0-ee', '8.10.0-ee'],
    'b0487ff30ff344be1c8e29c02c68b2aeedcdbc868a9a054065169b777f68bacd' => ['8.10.0-ee', '8.10.0-ee'],
    'c8a7a4d465ed3315520cb9ce5e8ab7289c06305bf73d6052bd49641b4afb6804' => ['8.10.0-ee', '8.10.13-ee'],
    '8efa85e0bb8eb60c14bc522c51920332446accc615f272370b01a02f991cc44a' => ['8.10.0-rc11.ee', '8.10.0-rc11.ee'],
    '30b3facddba001f46ba783f72d216cdc9f04624555ed5584136bf35e76269f84' => ['8.10.0-rc4.ee', '8.10.0-rc4.ee'],
    'a786873818cfc5b337b967a8b731771c7c93f7b712e7abd407fd6c9e7a812174' => ['8.10.0-rc5.ee', '8.10.0-rc5.ee'],
    'db8718149b464a5ca3ffd66141e0653e308f07f90d77c4f09fb2df5b1de6dec7' => ['8.10.0-rc6.ee', '8.10.0-rc6.ee'],
    '15be32588a86d2bd81c51584a423524cd6bc595122c97516bc649802672abcae' => ['8.11.0-ee', '8.11.0-ee'],
    '8f2f063b5f456816622faf59db393f4d0a20aabbec89eaf97a719d019c8595e1' => ['8.11.0-ee', '8.11.2-ee'],
    '1cb4bcd81170313f45967f9d4d3e56df032f2c08f7c12b0f8df1abb7c42f5435' => ['8.11.0-rc3.ee', '8.11.0-rc3.ee'],
    'e5fbee88d824ea692a816999b4e968e1a0c59a7ac9e67d94e06ceee82157e7cf' => ['8.11.0-rc4.ee', '8.11.0-rc4.ee'],
    '57870d00457d23fe9664ab49d2b1374dfb57d9663507365fd5a0cb29594826bc' => ['8.11.0-rc5.ee', '8.11.0-rc5.ee'],
    '26113f3f816e2bda75f9e77228011e42b5358dcd3f5b1f862853a6f9bf983b7b' => ['8.11.0-rc6.ee', '8.11.0-rc6.ee'],
    'a947f6d1d8b554d42849e57cb2554716dcc3dce7313e9912ea862145b430b09d' => ['8.11.3-ee.1', '8.11.3-ee.1'],
    '3bff75aac3689da6cbeae34d7923010badde0287f2ba1bd59ff9cc5bb7c0e72a' => ['8.11.4-ee', '8.11.4-ee'],
    'adad1d19c9ebe256763cfeb74286c980100b7ee346ad14650420bda5b6416c2f' => ['8.11.5-ee', '8.11.5-ee'],
    'bdb91c54fea423716aa41e608cbe3e115d138e71dad66656e29669be92e3d33d' => ['8.11.6-ee', '8.11.111-ee'],
    '430ffb5e6030e0154b3698d809d01e1976c8eb28e91980f4d4f3038f3882abeb' => ['8.12.0-ee', '8.12.0-ee'],
    '8f755a7e87f5a85f7204afa9a16ac8c8756bebe0a4a449b96ee5461930b1742e' => ['8.12.0-rc1.ee', '8.12.0-rc1.ee'],
    '1862488efbfdd4e52d469234dd5c9e9737f50278fd6b667aaaefe114928639e9' => ['8.12.0-rc2.ee', '8.12.0-rc2.ee'],
    '2c9aac5bec56ea20d47d5af35f0a41b9bfd0c861ad0059f06fb751a7b7522d10' => ['8.12.0-rc3.ee', '8.12.0-rc3.ee'],
    '64549d2f67e31f225f5cfed90adad482e2be7bc6c3e0e46efdc687b30020b84d' => ['8.12.0-rc4.ee', '8.12.0-rc4.ee'],
    '7da0a9336ec97118b77e29cdc7d85dac024722bd1b6c9de8fdc657c9f1152826' => ['8.12.0-rc5.ee', '8.12.0-rc5.ee'],
    'b1b0b46b4c4b3ce058cc100bced90b1c9a4ec8deda200eca48574ddce73c1389' => ['8.12.0-rc6.ee', '8.12.0-rc6.ee'],
    '35cc5485ae3048c288f8452f3cf0f7d7e4d4d10598f0914ee222678a491ba521' => ['8.12.0-rc7.ee', '8.12.0-rc7.ee'],
    '1e6247d4d158065518524adc9cfa419609c7acea9652dbdd4deca22a54e57b45' => ['8.12.11-ee', '8.12.11-ee'],
    '326006928d69e489e82ba482a9720e94ec4091b2b980397638d3dde5661cf979' => ['8.12.12-ee', '8.12.12-ee'],
    '00c531d39822e7163f06ccf1e7adf62377a1a103a6995f18fef1b2a0b563302f' => ['8.12.13-ee', '8.12.13-ee'],
    '1439ba31fbfa98d1461345e86c84ba6564c99859d1675c190ad1022f881acb33' => ['8.12.1-ee', '8.12.1-ee'],
    '88a00630bed823abcbb7953d5540a43e5fc740a6f5bc6a18fd069ee614716da9' => ['8.12.2-ee', '8.12.2-ee'],
    'e7e413170e4000849498241bb31dac2e9ca835e96456340b81b464f1fa375a44' => ['8.12.3-ee', '8.12.3-ee'],
    '8bda3c19a39ec9cb73e9f5464ac5f612097db76efd8cda2aa79de9888beecaa2' => ['8.12.4-ee', '8.12.4-ee'],
    '793ff873a3347733e10462a90197d124420b4b56b50387887f7debae2e126378' => ['8.12.5-ee', '8.12.5-ee'],
    'b7dd88bb3d77e5166e037beb21187602f3fcd0ac488baee4fcb522ddfa0a3ec2' => ['8.12.6-ee', '8.12.6-ee'],
    'd55380810e985c24c68fef215bb6450d1534c60907f99b52e871e8dc8dd7d791' => ['8.12.7-ee', '8.12.7-ee'],
    '82285fa1c9f752f6d0e339d7bdfabb10f7576cd469e8fccb5b17c22c73f080c1' => ['8.12.8-ee', '8.12.8-ee'],
    '34cc5edf39ab5f265034185d1984dc3336dd0e2d7a6a1c2e51c4beea30444f76' => ['8.12.9-ee', '8.12.9-ee'],
    '03e39e5fd8b86fc2c3027820832370da0f741467ea08cedc40f1aeab71ef5c29' => ['8.13.0-ee', '8.13.0-ee'],
    'c51d54a783a4f6c83344f5ff36fb4e5f69f3c8d1efce510f178309cc9c4b0f88' => ['8.13.0-rc1.ee', '8.13.0-rc1.ee'],
    '34c894656d286c436b3cf5524df77d0b6a8ab796049ed4e977cb40441989663f' => ['8.13.0-rc2.ee', '8.13.0-rc2.ee'],
    '87cb3479c0b13fe0c708339da37259d4762674cca8ad3965df8b48487b8e02d6' => ['8.13.0-rc3.ee', '8.13.0-rc3.ee'],
    'e4b9c060a00448314a6ab5b016706eb3e235b0d728b491226a934b5d04dff618' => ['8.13.0-rc4.ee', '8.13.0-rc4.ee'],
    'e0328d1096093e694b761295759ae13e671e1aba0d8cb957120631a3b43472cb' => ['8.13.1-ee', '8.13.1-ee'],
    '323fd2f4c852dd00344f67f61a24f301c7def6ee9eacff189c5fdcaa2fc77860' => ['8.13.2-ee', '8.13.12-ee'],
    '6b7773195c8a8e063c9b6a6de5a9e291c5d2a7ac6c607868334c8be2b9f30234' => ['8.14.0-ee', '8.14.0-ee'],
    '29308ba921ceb87d64d42e564c17d8962da07b8d9880e49d6b626da53185941e' => ['8.14.1-ee', '8.14.1-ee'],
    'cefbfaec30f892a04d76a07851937eaeb0aa18a860a83b098bee1ec43b0f0478' => ['8.14.2-ee', '8.14.2-ee'],
    '14b7c53c199c382a20467d28b0f14bc785ae2c26c3b53b6585eddc0bace7776e' => ['8.14.3-ee', '8.14.10-ee'],
    '985a889c9c28593407bc36080c067c288f607950d814f7f0464801d3c8048a47' => ['8.15.0-ee', '8.15.0-ee'],
    'd9759c148c78ce0720068721b29be2597182d32b5d0f5fde55b7a024ed6be756' => ['8.15.0-ee', '8.15.0-ee'],
    'a56c71f3f6a0fbb097695f49ac99a87dda2663947d45280991362864491e127f' => ['8.15.0-rc4.ee', '8.15.0-rc4.ee'],
    'ad18a5fef81413b7f282868c8d0be7007e98848325969a2001a05d46ef2d0327' => ['8.15.0-rc5.ee', '8.15.0-rc5.ee'],
    '891de7fec51aca5e492df8da1061c10ae6b4bee974c2039411f505fce2a0be9e' => ['8.15.1-ee', '8.15.1-ee'],
    '5ecd0810180ee15c1b96ab5e23eae651a55b939e5a35f0a63a7f1ab4b8cde941' => ['8.15.2-ee', '8.15.2-ee'],
    'c0c470a27a73630a1cf9f48118c9ccc14253f6a6e50bbe1872239c04fb7f1ab8' => ['8.15.3-ee', '8.15.8-ee'],
    '639a05d9dbd9ce8b3554308b68a3fcadeddd3845b466919caca8f6aa7f263627' => ['8.16.0-ee', '8.16.1-ee'],
    '5b98557d2f96e40270c56b79f9deb074fe842041bc9f9fee8ea83f70c0063a28' => ['8.16.0-rc2.ee', '8.16.0-rc2.ee'],
    '3583b7bc13f317be2df3f4758ea14a28b338e388b0079babdeebe4bbd9231569' => ['8.16.0-rc3.ee', '8.16.0-rc3.ee'],
    '5f69dd2bef40e266081e61c0d22b65c6a34ff84cdec0effeaec09ab7c9998d1d' => ['8.16.0-rc5.ee', '8.16.0-rc5.ee'],
    '3551bd381a663f42486d97201a7ddc28bcabab62747d790a6fb4dbf747fedb7c' => ['8.16.2-ee', '8.16.2-ee'],
    'cc7dd6188fbc8202c28fd4e43c2414b3006eaa3cb41354140c96d0056c57da8e' => ['8.16.3-ee', '8.16.3-ee'],
    'a6dd150d84720bf9a3c0d83ce742846db842b2f38248e1dd91159801d5aa5f41' => ['8.16.4-ee', '8.16.9-ee'],
    '1f580abc841e6473ed1b92ba59c60aadcb1f52dba21c5da10a5942663e555573' => ['8.17.0-ee', '8.17.0-ee'],
    'e364b8e72a9507319b25fd03b69fea255cf1eab9a47a1f79c849d774fc8e8783' => ['8.17.0-ee', '8.17.8-ee'],
    'fa980d49a253a51e83172337904b1978dbc69de43104a53d4133dbbc418a6494' => ['8.17.0-rc3.ee.1', '8.17.0-rc3.ee.1'],
    '7bf13edad59917878b63efba2486366a' => ['8.2.4-ee', '8.2.5-ee'],
    '833807b5c778268c8229d8bc78c9856e' => ['8.3.5-ee', '8.3.10-ee'],
    'b50e0477d0d18c817f77a8bc559fb925' => ['8.4.6-ee', '8.4.11-ee'],
    '254656ed7089daeabc34dace879988f4' => ['8.5.6-ee', '8.5.13-ee'],
    '6c7f110da08da882c8794105d206651cf8bacf41f4c5927867a80a2cd1f33575' => ['8.6.0-ee', '8.6.0-ee'],
    'f11a89be9ea71c322f2b6389f15978c6696ce4949908c33c2fe70cd3fd63d7a6' => ['8.6.1-ee', '8.6.1-ee'],
    '65a19c35a07d9eb970b331633f1fb86adb02191b520e01e428b089718ed0176f' => ['8.6.2-ee', '8.6.9-ee'],
    '726a5c07a9fe6e166863687a52f31cab16e7505c12be0274d2879288dd772f0c' => ['8.7.0-ee', '8.7.0-ee'],
    'd1b443fde75ed177fd9adacfbb24b9452837678ad142720bd93f166b3a41b966' => ['8.7.0ee', '8.7.0ee'],
    '013f96e2e298ff24e084b1b4f88b84bfa0bb9554d3adc09cdaa748a988fef55e' => ['8.7.0-rc1.ee', '8.7.0-rc1.ee'],
    'c5f4787f626a418b75ce37b6a819774dec3efaf4db670a65be67f6dbeba7a161' => ['8.7.1-ee.1', '8.7.1-ee.1'],
    'f74617d691520eec9f5146b18808de6df11edfb14391b31ad1bf977b7c903d58' => ['8.7.2-ee', '8.7.9-ee'],
    'f6df5a78daa7dd1e3b7ed3ee125bde49abd4ec535ea9b33348c3025b57c45238' => ['8.8.0-ee', '8.8.1-ee'],
    '8a440eb55ebce343e42e8f421d631002727bc7e675427907e72624cfea42105d' => ['8.8.0-rc1.ee', '8.8.0-rc1.ee'],
    'a260be8946c581d604e7a08f17f4dd8ae9c5b5e64fcb8579a2f73ff7a924ef9b' => ['8.8.0-rc2.ee', '8.8.0-rc2.ee'],
    'c722cebbbf1fa0a0807cf33b931259195d7ce0e220f5804004a13f584415454c' => ['8.8.2-ee', '8.8.2-ee'],
    'afebf7c24396711dd531d20f604b423e691440bb71a4c6294263ad17f063da01' => ['8.8.3-ee', '8.8.9-ee'],
    '227acddb7391d568526f8a353f4ac35af9ab5dfd9135b192b96fa7e903416e2c' => ['8.9.0-ee', '8.9.0-ee'],
    'e7685b052ecb55ee9a3333cc5e86d4234231d3272c552928efb9107ed16f4ebc' => ['8.9.0-rc2.ee', '8.9.0-rc2.ee'],
    '4136c62f8c363c1c8876082e8a188fe79625e25aa607b42e2853bdfd90f12dc8' => ['8.9.0-rc3.ee', '8.9.0-rc3.ee'],
    'a5cacde7986606e2768747890df34ac52b30391daa7f0cd817a7deb0269cd310' => ['8.9.0-rc4.ee', '8.9.0-rc4.ee'],
    'cdc3e489935076f063aeaf2f0c0d7f0b12d677dc69cc178c45b73dc64c3af3b6' => ['8.9.0-rc5.ee', '8.9.0-rc5.ee'],
    '580a06aeb3fc7976ea8289de3f6c8da30d26144be8ae764a8fcff60875f30bff' => ['8.9.0-rc6.ee', '8.9.0-rc6.ee'],
    '65b1626ff3ea11fb637c6cbbbb434e73523842fccaa2fa216c941aabb5f99968' => ['8.9.0-rc7.ee', '8.9.0-rc7.ee'],
    'eb8d24a0f1bb6f18f62a92d76e4043b007edf15c892c6690383c5fe43c0906aa' => ['8.9.0-rc8.ee', '8.9.0-rc8.ee'],
    'd18f6847c9149fa177d899dccbbfb25add0ba19612a9b1fdaa074b3b1689fd7d' => ['8.9.1-ee', '8.9.2-ee'],
    'c6db12cc8b9527dbb63611a1217c99ae6d9e693f7b457cdccf6d617d2a8892fb' => ['8.9.3-ee', '8.9.3-ee'],
    '71dea6cf3a1324c4a0e0a3a4ac58d343b17da225298ddcdfb6cf771d57958e7e' => ['8.9.4-ee.1', '8.9.4-ee.1'],
    '7e26eb81eed3b6f4e5c16fe8fffc414a242d0318e8082c4348ce4fea47c242bb' => ['8.9.5-ee', '8.9.5-ee'],
    '7aab000e1e53fd7db0a82941df95594781dac1c6c495c8c8c2cbfd24832b04dc' => ['8.9.6-ee', '8.9.11-ee'],
    '136047ab2386ebbdeb9e37f0a63f4579b5373d6aba77904589b173fca51d555d' => ['9.0.0-ee', '9.0.0-ee'],
    '4c2335ce30995b624545c4da925a91116c80bdf40a00240cb4add6922d1939b0' => ['9.0.0-ee', '9.0.0-ee'],
    'f692186c449c244070a2adde2de343c5daf200e5f9e42b3fa6691dd5c154d606' => ['9.0.0-ee', '9.0.0-ee'],
    '5ea017eceb108b0d68119c1ed53af56953c06e27e677be9602ab111211ca5c3c' => ['9.0.0-rc3.ee', '9.0.0-rc3.ee'],
    'ffca946305ba0905249ae15441aad5f454ce88269149ab51d65906a12fa54dfa' => ['9.0.0-rc6.ee.1', '9.0.0-rc6.ee.1'],
    '5712c5b815894bb84e3a13aab311d7491149a9f4fa4a60aa266cddafed1be1cf' => ['9.0.10-ee', '9.0.13-ee'],
    '3850d331f06aaf20cf271289e74ddafc6dea83657cb9bd3975a09b33da9f73da' => ['9.0.1-ee', '9.0.4-ee'],
    '832385585f303dbbef035295e8eaf0a84ad56b19d66d2d5f921ef260f6ac5449' => ['9.0.5-ee', '9.0.5-ee'],
    '8ab51593afe57c1fa69bdc0b6a299945f93f2b4eafecb4665f8928da7f11bd11' => ['9.1.0-ee', '9.1.0-ee'],
    'a7f117377af877b16a68903d6652f5453762cac3af0025ccee9a8d9b2924fbd4' => ['9.1.0-rc1.ee', '9.1.0-rc1.ee'],
    '9b48e4e8ebd99ac84fe4982bcee3f5824a3183f6774ee6d0d0c46a18591f0fd0' => ['9.1.0-rc2.ee', '9.1.0-rc2.ee'],
    'ba36eab655ebb60ecc90302c30b87f9ed3f3194d6d3627dec00206eb63759b50' => ['9.1.0-rc3.ee', '9.1.0-rc3.ee'],
    'e335eb98625796d0cb4844f2ee6dc364a756f197d5c8d2795253cc68fcc388d8' => ['9.1.0-rc5.ee', '9.1.0-rc5.ee'],
    'deec1c22081bff149f8fb85da15421473dde608124333c9a87f406c801c1b53a' => ['9.1.1-ee', '9.1.3-ee'],
    'f7b1af7f2a73316553b55f1ab29a61d8ab865741f957c81f3cd1f6cd01e0ba08' => ['9.1.4-ee', '9.1.10-ee'],
    '44459dbfb37fc6d7da5523ce0d0edf10d262b504a4ddd4c49a7d669a9847d470' => ['9.2.0-ee', '9.2.0-ee'],
    'd6d5032aa44f17e5a3b181b10493bfd6b787a1f19f9f6d390b30eca56c4c822a' => ['9.2.0.ee', '9.2.0.ee'],
    '4e4654773873090de9f02614df032e5de21b90ea1e0b2f7dceeec831869d11e5' => ['9.2.0-rc5.ee', '9.2.0-rc5.ee'],
    '7371a6c8e890f7dc8f3b2e2522167868f7a6e5d41e1cee3062866b52010b4a96' => ['9.2.0-rc6.ee', '9.2.0-rc6.ee'],
    '11ce0e12859c6ae9416157e547281ea30c48eb14c0904e73ac606372fe436916' => ['9.2.1-ee', '9.2.1-ee'],
    '6a9fe2c33b8b16c8edbae2e8b770f63a8b692869438cb6a69ba65e1e90e9b3ac' => ['9.2.2-ee', '9.2.5-ee'],
    'a45cec3727d52121c79d7450e30b91f7ecb4c07ece0a7bf77325b87c1e94ef51' => ['9.2.6-ee', '9.2.10-ee'],
    '579a6a72701478ef5e780603015e3c9ce92fc5a5a51492c3e931130462191e18' => ['9.3.0-ee', '9.3.0-ee'],
    '6b433a9a80b39684ecda0f48138b86339464ccb8bb705eb76d79943a6097781d' => ['9.3.0-rc3.ee', '9.3.0-rc3.ee'],
    '5612229cbfaca8f3d5778afdaa3132bef1acf83b33b02fc4ca9582826fcd1cf6' => ['9.3.0-rc4.ee', '9.3.0-rc4.ee'],
    'bd0591e7f83c5c757eafb06a790e3c2eb596023cde502b711d542826bf1c2964' => ['9.3.0-rc5.ee', '9.3.0-rc5.ee'],
    '614a81c79e2ce45c18c3807b0f0cb218d514392a08f79d088b3e1a0cb6f26105' => ['9.3.0-rc6.ee', '9.3.0-rc6.ee'],
    'b32f14d4a18428010a0120124ac71c64dbd115448e9452f69f4aa03ed6f6f2c1' => ['9.3.1-ee', '9.3.1-ee'],
    'c93d54262d93bf9be7bf92d1042c63ebb671b23626f562451ad56ac23c494384' => ['9.3.2-ee', '9.3.2-ee'],
    '04fd83c9ae66fcbbe72dbcd17e6aa57368b46f28cd6627eac7be7e9b4bdcdd4e' => ['9.3.3-ee', '9.3.4-ee'],
    'bf562c36db4b06702ba455fb509cdac15b6f7b5797112e8a3784394849c9bb3b' => ['9.3.5-ee', '9.3.5-ee'],
    'bfee594e17b667a19ce07c6708724475a7b560826478e703bac686f4bf6dcc0b' => ['9.3.7-ee', '9.3.11-ee'],
    '0ce138c5acfa8d6b4ca34a3b0d47dbf66e10ef7dbd7e6ae7dad4cf37d6bc757d' => ['9.4.0', '9.4.0'],
    '7f896d12e8c3d750d5d268b510f38dca7d4c33d23a668f1f3798da31c24c963e' => ['9.4.0-ee', '9.4.0-ee'],
    '33bab1675aae866fe5433ed9a64acfcfbdc7c4b143789ec29a0d9682acd0312a' => ['9.4.0-rc2.ee', '9.4.0-rc2.ee'],
    '651ebf72c86a48489adbda90ce3947b25431fb1b12c6ac6e9a3ffd5d3c413a82' => ['9.4.1-ee', '9.4.1-ee'],
    '351a519e3c07d63c12fb2e18420b899ed1e9ad8c1fce310ebd7ebffb4b172972' => ['9.4.2-ee', '9.4.2-ee'],
    '098c89427cd896dada8c3cae23befccda47ecc1f464530f98df4cb9e6751c6f9' => ['9.4.3-ee', '9.4.4-ee'],
    '2c803027ae984fac8288b763e7e503c2e7683dfb912f304efb55b4bd41f1ff4c' => ['9.4.5-ee', '9.4.7-ee'],
    '904c5ee5abdd1450193f624c29116ac990837add5a100d7edd6f463281228e54' => ['9.5.0-ee', '9.5.1-ee'],
    '1b16a5c5da5cb45aecd61cfefab2132b5b3ba9a288e05b0b3424b06022db48b1' => ['9.5.0-rc2.ee', '9.5.0-rc2.ee'],
    'f1c00fa94ac7f2016c129335f5076f0cfdd3361e2333a242730949c7a797ef35' => ['9.5.0-rc4.ee', '9.5.0-rc4.ee'],
    '7bc62ec5949747362268e3a5ee5b939dfd55011ab2a1359a2acd038a69e9159f' => ['9.5.0-rc5.ee', '9.5.0-rc5.ee'],
    'e531fbea315a337c31f4d15692b5ff882cafd3163d2b9179b9193e0bd3a9f6d6' => ['9.5.2-ee', '9.5.2-ee'],
    'e8d4b9ffa3c3ac85895355ad3a6fed9b9d97a9b1e2d2af73cf89682a3b66eb7f' => ['9.5.3-ee', '9.5.4-ee'],
    '3ccde03e5603f96b98117cf64b61c1a6316dd639af6d326871856cdc4dd5d358' => ['9.5.5-ee', '9.5.5-ee'],
    '60e171e3b0d8bdeb03200364775fde3b96ca01a82c3b2cfe49ebcbfc625c5a7d' => ['9.5.6-ee', '9.5.7-ee'],
    'd7adb1ce21c0c8ed6eee1d7d410467c0e04fca2127e5c6fc783ba31d3468b767' => ['9.5.8-ee', '9.5.10-ee'],
    '61d4cb7e100f2fac8ccaeac5e18d08f97554f0639e84004165d6f9697cfbe08c' => ['10.0.0-ee', '10.0.1-ee'],
    '736cd6d9720e0fd42b9b19bf3754eb919d7d4035d775fecf6cad093eca50c17a' => ['10.0.0-rc2.ee', '10.0.0-rc2.ee'],
    '465a44749e3208038b75d613d9fbd86837022b634e4c91d109b8d5d42751ec4b' => ['10.0.0-rc4.ee', '10.0.0-rc4.ee'],
    '1f7b64b4d7fe82dfdb0a04087d7f83612a5de0013afc5bd2bc859e7a35f83a68' => ['10.0.0-rc5.ee', '10.0.0-rc5.ee'],
    '6a3ef04d2d06f6f387f3926420b39edb4fcbcc563aedc3dc9a94e19092c3752b' => ['10.0.2-ee', '10.0.4-ee'],
    '71d782abb58e8d6aeef6b922fabf23790fdee4a54031a4c96fd9e525260fae73' => ['10.0.5-ee', '10.0.7-ee'],
    'b35839696e0c94973d6764ffabdda51d8ca017d8a0362bfb822868dae8ebcc6e' => ['10.1.0-ee', '10.1.0-ee'],
    'f2def36a2bcd72f8b882f554db8478003138e58d87668ee1cded34cf937d2f18' => ['10.1.0-ee', '10.1.0-ee'],
    '725ece27f57ae718b88883b83d939fac50f3e40c1c5788821bd7572f62a34014' => ['10.1.1-ee', '10.1.2-ee'],
    '6207d5e2a3a1b538c597a2874e8c165e9f4aeac1037162c59235275d70f6f906' => ['10.1.3-ee', '10.1.7-ee'],
    'e656e2e80f80b00dd45fbb306d08f5ab24d5309e96254fba51aaaa851e834038' => ['10.2.0-ee', '10.2.1-ee'],
    '9964e3ff459219f204c234fc5fbec1010acef42f900b0f909535a21f36a13823' => ['10.2.0-rc2.ee', '10.2.0-rc2.ee'],
    '0c402d597b5cd9e799fb1acc9d4a4e73fbc513f7d2aa380bf36b1eb658563e4e' => ['10.2.2-ee', '10.2.2-ee'],
    '51f314b9320d45e0742619643318b03352ea71cfbadbd7c3ce5f590461cabf94' => ['10.2.3-ee', '10.2.4-ee'],
    'ea39533dd7b6fe48e45039a2ca569e15148d684c77345688e83902b157c3fef8' => ['10.2.5-ee', '10.2.8-ee'],
    '62f6ae20d1ea8965d920649efa7a3bced3ac772bf937ed4dbf3bb6d722f447a1' => ['10.3.0-ee', '10.3.0-ee'],
    '476f4ca22df7463aa2be1f4d700a3f15408ec4787790db6700d7e213122656ba' => ['10.3.1-ee', '10.3.5-ee'],
    '143e9184cef71f7e13a5340b4b265a5d9d60bfe6185bb4eb13b68037e8ecd176' => ['10.3.6-ee', '10.3.9-ee'],
    '2c6f04e842572e26b532791d724401497b510ebbd1244ad88993fdccbc6bb950' => ['10.4.0-ee', '10.4.0-ee'],
    '9543fbb0c156fdefa27e586f322a6156a1fb76116ad3661f5f0f509bc52faa6a' => ['10.4.0-ee', '10.4.0-ee'],
    '367d211cf9ba4d8b92fa489d43fc541b89d366c2f4336e4b0b6146d72298b434' => ['10.4.0-rc2.ee', '10.4.0-rc2.ee'],
    '2a408b69a4096cb46952a9e350779aaf260fa4e7b13a0f0918a58388ade8498c' => ['10.4.0-rc6.ee', '10.4.0-rc6.ee'],
    '7d7c2a8f76f25eba3ecd13d8607668efb963fc65f69435480a1e7a6fccd55164' => ['10.4.0-rc7.ee', '10.4.0-rc7.ee'],
    '22d546867df2b0d956152bb7c509cabe6435b87b5a23984828603e09b016c156' => ['10.4.1-ee', '10.4.3-ee'],
    '63c1c0e4f3a6f8e52e51d24008407cf46b1f38d0a27f1f21cfa6987206f5c61a' => ['10.4.4-ee', '10.4.7-ee'],
    '744d9cf88c3d704c83b6473f0d1c72072064c8473fe0f15d6c04fd958d364514' => ['10.5.0-ee', '10.5.0-ee'],
    'd68f15e84adf870aff4f0a9adf1ead3779933d0aa003544b3dd69350615da261' => ['10.5.0-ee', '10.5.0-ee'],
    '43d9846263acb0cb0bf525c010ee6ff739532c8149e84bb68004ff0be5d4e32d' => ['10.5.0-ee', '10.5.1-ee'],
    '928b9ae7d13cc12d538b90d4c2302c30b61ae8bd4d7968948459ad20ca3b162a' => ['10.5.0-rc5.ee', '10.5.0-rc5.ee'],
    'd4ff7871824e8559baf0b3a8728a1fec0bc9dcca2434f7df6d27bda5dcaaea3d' => ['10.5.2-ee', '10.5.8-ee'],
    '4dcc9c194fd148bc19c8f5cd92fda820c3aeeee0ff9de9c2b228795976a11232' => ['10.6.0-ee', '10.6.3-ee'],
    '7af716af52cd92da4c095d83e097200491a752a20f4bc34567b042a9403da10e' => ['10.6.0-rc3.ee', '10.6.0-rc3.ee'],
    '1bd7c0c136fc1d99a58fea471e4f6ca5b04a865451950756f642c6e8b273cdeb' => ['10.6.4-ee', '10.6.6-ee'],
    'b73d5f8ec9dcb2e5e31f36455bcf11e78615f802f0c1cd5e8f217d2fcb825f84' => ['10.7.0-ee', '10.7.0-ee'],
    '14a2faf8c0c02a011c92c3cff330a7af8b5c862faa505d32575e18704925beab' => ['10.7.0-rc4.ee', '10.7.0-rc4.ee'],
    'fcfc51811106a608f05318a21ea570b0f4d6540c891c3903a3220b02d8a76cbd' => ['10.7.0-rc5.ee', '10.7.0-rc5.ee'],
    '7dd45a23dafef4b5ec7501ed3737cfd023a850e0b9b27ed5e2493ffdb44a1a7f' => ['10.7.1-ee', '10.7.7-ee'],
    '227e4874e1aa27b3bb7c26531b5b0fa476969075b07fa9f94d1e6949291fa273' => ['10.8.0-ee', '10.8.0-ee'],
    '0a8855fb7aa281d41c4cf9cef79b1cb8d8dae6734ccd7f1e6f4a6434519c1745' => ['10.8.0-ee', '10.8.3-ee'],
    '654dfd2c02876008b12bdf4fdda62e2e95999c6a4a8af19ad88acf5608caf75d' => ['10.8.0-rc3.ee', '10.8.0-rc3.ee'],
    '78153eabee92244c739095a0acf7cd17ad4b82eb80eced6eef28fd19d0efd84d' => ['10.8.0-rc7.ee', '10.8.0-rc7.ee'],
    'a5f1c38c7c83df455caac2d4c519518af784ea874dd0eed37fc14cee84a5789d' => ['10.8.4-ee', '10.8.7-ee'],
    '48519e23c3b52f8d1e6722e2daca2a36abb720a4dc6ed6e6fa946992afd14272' => ['11.0.0-ee', '11.0.1-ee'],
    '7ea12aee81599e03ec57f77b6eeec229afd6bb8b94978c5253b04da1dc130374' => ['11.0.0-rc10.ee', '11.0.0-rc10.ee'],
    '6013add4b1e9e14df0273bd1ab08f0223d498c1da55588ed94bf364b3d69e5b5' => ['11.0.0-rc11.ee', '11.0.0-rc11.ee'],
    '407dcaa12fc2fd5534c480122458e7dda18b7545add72fef36ba64c49371724e' => ['11.0.0-rc12.ee', '11.0.0-rc12.ee'],
    '4826b350019a4ced33b26b93e7339f3d795fb341fd4f5db6cb7c832fe8e7dfef' => ['11.0.0-rc13.ee', '11.0.0-rc13.ee'],
    'a09e511ed84295f9200da27122bf8cdc04172e802a216b3e07b0dcb1b56210a9' => ['11.0.0-rc5.ee', '11.0.0-rc5.ee'],
    '531abfd38df903639c074050d14072b6535389caf574cffdced33fbb269489ee' => ['11.0.0-rc9.ee', '11.0.0-rc9.ee'],
    'd6c60a08a76fa06abb456f326abe397a5a2902cd7607da8389f69d2aff222469' => ['11.0.2-ee', '11.0.2-ee'],
    'a0c27ebc9fab63b1fcfe785204cae24d6054aca4cef438c8619d5941d9a9b37f' => ['11.0.3-ee', '11.0.6-ee'],
    '67ac5da9c95d82e894c9efe975335f9e8bdae64967f33652cd9a97b5449216d2' => ['11.1', '11.1'],
    '93ebf32a4bd988b808c2329308847edd77e752b38becc995970079a6d586c39b' => ['11.10', '11.10'],
    'e4b6f040fe2e04c86ed1f969fc72710a844fe30c3501b868cb519d98d1fe3fd0' => ['11.10.0-ee', '11.10.3-ee'],
    '7b1dcbacca4f585e2cb98f0d48f008acfec617e473ba4fd88de36b946570b8b9' => ['11.10.0-rc6.ee', '11.10.0-rc6.ee'],
    '2eaf7e76aa55726cc0419f604e58ee73c5578c02c9e21fdbe7ae887925ea92ae' => ['11.10.0-rc7.ce.0', '11.10.0-rc7.ce.0'],
    '9b4e140fad97320405244676f1a329679808e02c854077f73422bd8b7797476b' => ['11.10.0-rc7.ee', '11.10.0-rc7.ee'],
    '335f8ed58266e502d415f231f6675a32bb35cafcbaa279baa2c0400d4a9872ac' => ['11.10.4-ee', '11.10.5-ee'],
    '38981e26a24308976f3a29d6e5e2beef57c7acda3ad0d5e7f6f149d58fd09d3d' => ['11.10.5-ce.0', '11.10.5-ce.0'],
    '14c313ae08665f7ac748daef8a70010d2ea9b52fd0cae594ffa1ffa5d19c43f4' => ['11.10.6-ee', '11.10.8-ee'],
    '1d86daecfb6704a29ef0e9f42ab3478baed22a68f8e1f8aa719ec7a8698d2129' => ['11.1.0-ee', '11.1.0-ee'],
    '5371dfb9eb8c471865f19a3509e67dc7eddeab501925c50bbf3c76667fdc67dd' => ['11.1.0-ee', '11.1.0-ee'],
    '565000dc4886e53b51b6409cbdf794636da759435e3eb6bf91481577b5cd2936' => ['11.1.0-ee', '11.1.2-ee'],
    '00218192eb99e497b44466d84dce80711dd32031561e8e4449e16d8b46a8cbde' => ['11.1.0-rc10.ee', '11.1.0-rc10.ee'],
    '1e9f9cb052c09a5dd3e3e030b1f554ed8cd9707749bbef90b36e77fdcc6ef844' => ['11.1.0-rc2.ee', '11.1.0-rc2.ee'],
    '77f52c17f8dc65b5a58be8ec19e2655ec43f5edca86718fc3461fd8bcf1ab734' => ['11.1.0-rc9.ee', '11.1.0-rc9.ee'],
    '5440e2dd89d3c803295cc924699c93eb762e75d42178eb3fe8b42a5093075c71' => ['11.11', '11.11'],
    '39b154eeefef684cb6d56db45d315f8e9bf1b2cc86cf24d8131c674521f5b514' => ['11.11.0-ee', '11.11.1-ee'],
    '9c095c833db4364caae1659f4e4dcb78da3b5ec5e9a507154832126b0fe0f08e' => ['11.11.0-rc1.ce.0', '11.11.0-rc1.ce.0'],
    '69a1b8e44ba8b277e3c93911be41b0f588ac7275b91a184c6a3f448550ca28ca' => ['11.11.0-rc1.ee', '11.11.0-rc1.ee'],
    '34031b465d912c7d03e815c7cfaff77a3fa7a9c84671bb663026d36b1acd3f86' => ['11.11.0-rc4', '11.11.0-rc4'],
    '318ee33e5d14035b04832fa07c492cdf57788adda50bb5219ef75b735cbf00e2' => ['11.11.2-ee', '11.11.8-ee'],
    '10723f1f6d76069649a38e767f7bfe21dcffa233b627b12a612b5f64a597096c' => ['11.1.4-ee', '11.1.8-ee'],
    'f5d81adbf6c6bdff2a8a35bc3f81c38e0114198d672d3f105b0d86e16d533c15' => ['11.2.0-ee', '11.2.8-ee'],
    '3d21830b6fae3f07deda5535c72da8fe29ef4ade91988ce13abf415a5acc727f' => ['11.2.0-rc2.ee', '11.2.0-rc2.ee'],
    'd42d0daba18ba8e1cb670c81dbec9247b3e7d50a5652249abf9efdc470ba838e' => ['11.2.0-rc5.ee', '11.2.0-rc5.ee'],
    '941aeff80cedd88753e7f78eb85065396e7bf4b363572b28e44ae41939250dd9' => ['11.3.0-ee', '11.3.14-ee'],
    'df08f164bd8fc06fee40aea28ed977562d6178e81e9c885e797acbf0b9ed1b06' => ['11.3.0-rc1.ee', '11.3.0-rc1.ee'],
    '367ee28873f9e3f90b56617182f9eded9ad2dbd834f7279d5771980e1858b411' => ['11.3.0-rc2.ee', '11.3.0-rc2.ee'],
    '9c0b9f88e9d4f58f2f324de036d9ed06bb0fec04823b9014b56a5c6f5a440609' => ['11.3.0-rc3.ee', '11.3.0-rc3.ee'],
    'e3182d6c67e7d0af69c121334cf15f1aead49770fad5f932b3c73681cdb4c76e' => ['11.3.0-rc4.ee', '11.3.0-rc4.ee'],
    'ee729e68e20fd48420f7b7a71a2683acf5e29502c7573b7732b7a3938a231de9' => ['11.3.0-rc6.ee', '11.3.0-rc6.ee'],
    'cc8b10386416bb809ddda918461bc510e8e331065d45164542a183e2121c0e0d' => ['11.3.0-rc8.ee', '11.3.0-rc8.ee'],
    '6ee66cce5d1f698b34551984045f965d2fa23a591a2359ad46db895585fc5425' => ['11.4.0-ee', '11.4.0-ee'],
    'ec9cb1dcec808a1fc7b73149cb53653971c4ff1fafde770f95352f8d1aaabed6' => ['11.4.0.ee', '11.4.0.ee'],
    '76e59ad17a8438df5ab03d9d5ea0e161c5210773e7ffd24137f25d252de446da' => ['11.4.0-ee', '11.4.14-ee'],
    '029b11228648f3d7ec40a97a51f03037cc05edd767dd795372d28c9c9406a6f4' => ['11.4.0-rc1.ee', '11.4.0-rc1.ee'],
    '7bb66f18e566b1939449ac21518983d5b3c1b3b133fe717a7a50d6534f92d337' => ['11.4.0-rc5.ee', '11.4.0-rc5.ee'],
    '13fc6fb0080f970531f362e3f65c6772c7034257d571cc92120d42d9bb48f78d' => ['11.5.0-ee', '11.5.0-ee'],
    '2bc937bdbf16463139855a4f2d14aa5747dc697192760e8ef459d226474d726f' => ['11.5.0-ee', '11.5.1-ee'],
    'f2648cbebd29e610e8cf5279ea0f7a07ee89201912cbb0eae5b49fe078329748' => ['11.5.0.ee', '11.5.7-ee'],
    'd0a83efe7c1766eb01d1e396c39feb47ffb22ca5f714b75065877ec341dda0b1' => ['11.5.0-rc4.ee', '11.5.0-rc4.ee'],
    '91544b7d799d1652a1d396c7d0c846fc4894d153f9b8a8302fd450839e2209a3' => ['11.5.0-rc7.ee', '11.5.0-rc7.ee'],
    '916422d517b997227afbf31cb24411489bca80d9d0ea112ce2d11d4b37ee2a57' => ['11.6.0-ee', '11.6.1-ee'],
    'da21f1f87635c2914860210c6714b21e6b787e8c92459a8073fca86c07904dd4' => ['11.6.0-rc4.ee', '11.6.0-rc4.ee'],
    '1eab6d041ca7e496357f5a4d37fcf9f0cad67658499af659bb5ce4da47b98a4d' => ['11.6.0-rc7.ee', '11.6.0-rc7.ee'],
    'd8ef3ca93b9bc3682234c992030b943a54a4718c100e83bf5f1b2639a35871ef' => ['11.6.2-ee', '11.6.11-ee'],
    'd2dc5140805b02e90dbb2eef91a5bc6c224c89f6664ba90777b3c1421e025375' => ['11.7.0-ee', '11.7.4-ee'],
    '750342d92340ba0687cbe3e072d04a1c83e84c608388853b2cd23bc3a46195cd' => ['11.7.0-rc4.ee', '11.7.0-rc4.ee'],
    '7658423a584f4f90c75eb926768416d6628b34f5c764aeb64513a48924114b1f' => ['11.7.5-ee', '11.7.12-ee'],
    'ed7c9d893caa008ca270c5e7b4fc8e9524f6a30fff77ed56cd7ecf4d93fdf447' => ['11.8.0ee', '11.8.0ee'],
    '0353aa5e37cc69c4f5a1b03307f06eb50873ac823ade8ed661be043dbb0d13ce' => ['11.8.0-ee', '11.8.1-ee'],
    'fa46967b835cae298448bdd6d5e5935fbae5d5863680e74a04f589f3675ad126' => ['11.8.0-rc2.ee', '11.8.0-rc2.ee'],
    '588545f3ea7d36dcacdd78d46e59bdd7013af7727e7942844bdb720b12fb64f8' => ['11.8.0-rc5.ee', '11.8.0-rc5.ee'],
    'a038bd37f8a472ec87046602d735d567de50a245d88ce60d046f516eeb3174fe' => ['11.8.0-rc6.ee', '11.8.0-rc6.ee'],
    '65e5ccac7a05cf06546dca2d4fff44bb5efa750000bc78c2a16636cf69bcaa7e' => ['11.8.2-ee', '11.8.10-ee'],
    '3cbf1ae156fa85f16d4ca01321e0965db8cfb9239404aaf52c3cebfc5b4493fb' => ['11.9', '11.9'],
    '292ca64c0c109481b0855aea6b883a588bd293c6807e9493fc3af5a16f37f369' => ['11.9.0', '11.9.0'],
    '3963d28a20085f0725884e2dbf9b5c62300718aa9c6b4b696c842a3f4cf75fcd' => ['11.9.0-ee', '11.9.0-ee'],
    '530a8dd34c18ca91a31fbae2f41d4e66e253db0343681b3c9640766bf70d8edf' => ['11.9.0-rc3.ee', '11.9.0-rc3.ee'],
    '64e10bc92a379103a268a90a7863903eacb56843d8990fff8410f9f109c3b87a' => ['11.9.0-rc7.ee', '11.9.0-rc7.ee'],
    'f7d1309f3caef67cb63bd114c85e73b323a97d145ceca7d6ef3c1c010078c649' => ['11.9.1-ee', '11.9.12-ee'],
    '77566acc818458515231d0a82c131a42890d771ea998b9f578dc38e0eb7e517f' => ['12.0', '12.0'],
    '504940239aafa3b3a7b49e592e06a0956ecaab8dbd4a5ea3a8ffd920b85d42eb' => ['12.0.0-ee', '12.0.12-ee'],
    '78812856e55613c6803ecb31cc1864b7555bf7f0126d1dfa6f37376d37d3aeab' => ['12.1', '12.1'],
    '450cbe5102fb0f634c533051d2631578c8a6bae2c4ef1c2e50d4bfd090ce3b54' => ['12.10', '12.10'],
    '4448d19024d3be03b5ba550b5b02d27f41c4bdba4db950f6f0e7136d820cd9e1' => ['12.10.0-ee', '12.10.14-ee'],
    '340c31a75c5150c5e501ec143849adbed26fed0da5a5ee8c60fb928009ea3b86' => ['12.1.0-ce.0', '12.1.0-ce.0'],
    'ef53a4f4523a4a0499fb892d9fb5ddb89318538fef33a74ce0bf54d25777ea83' => ['12.1.0-ee', '12.1.3-ee'],
    '4568941e60dbfda3472e3f745cd4287172d4e6cce44bed85390af9e4e2112d0b' => ['12.1.0-rc1.ee', '12.1.0-rc1.ee'],
    '33313f1ff2602ef43d945e57e694e747eb00344455ddb9b2544491a3af2696a1' => ['12.1.4-ee', '12.1.17-ee'],
    'd56f0577fbbbd6f159e9be00b274270cb25b60a7809871a6a572783b533f5a3c' => ['12.2', '12.2'],
    'b64a1277a08c2901915525143cd0b62d81a37de0a64ec135800f519cb0836445' => ['12.2.0-ee', '12.2.12-ee'],
    'def1880ada798c68ee010ba2193f53a2c65a8981871a634ae7e18ccdcd503fa3' => ['12.3', '12.3'],
    'bb1565ffd7c937bea412482ed9136c6057be50356f1f901379586989b4dfe2ca' => ['12.3.0-ee', '12.3.9-ee'],
    '3407a4fd892e9d5024f3096605eb1e25cad75a8bf847d26740a1e6a77e45b087' => ['12.4', '12.4'],
    '0a5b4edebfcb0a7be64edc06af410a6fbc6e3a65b76592a9f2bcc9afea7eb753' => ['12.4.0-ee', '12.4.8-ee'],
    'd812b9bf6957fafe35951054b9efc5be6b10c204c127aa5a048506218c34e40f' => ['12.5', '12.5'],
    '73a21594461cbc9a2fb00fc6f94aec1a33ccf435a7d008d764ddd0482e08fc8d' => ['12.5.0-ce.0', '12.5.0-ce.0'],
    'eb078ffe61726e3898dc9d01ea7955809778bde5be3677d907cbd3b48854e687' => ['12.5.0-ee', '12.5.2-ee'],
    '1626b2999241b5a658bddd1446648ed0b9cc289de4cc6e10f60b39681a0683c4' => ['12.5.3-ee', '12.5.10-ee'],
    'aeddf31361633b3d1196c6483f25c484855e0f243e7f7e62686a4de9e10ec03b' => ['12.6', '12.6'],
    '70ce56efa7e602d4b127087b0eca064681ecdd49b57d86665da8b081da39408b' => ['12.6.0-ee', '12.6.8-ee'],
    'bec9544b57b8b2b515e855779735ad31c3eacf65d615b4bfbd574549735111e7' => ['12.7', '12.7'],
    '39fdbd63424a09b5b065a6cc60c9267d3f49950bf1f1a7fd276fe1ece4a35c09' => ['12.7.0-ce.0', '12.7.0-ce.0'],
    '40d8ac21e0e120f517fbc9a798ecb5caeef5182e01b7e7997aac30213ef367b3' => ['12.7.0-ee', '12.7.0-ee'],
    'ed4780bb05c30e3c145419d06ad0ab3f48bd3004a90fb99601f40c5b6e1d90fd' => ['12.7.2-ee', '12.7.9-ee'],
    'dc6b3e9c0fad345e7c45a569f4c34c3e94730c33743ae8ca055aa6669ad6ac56' => ['12.8', '12.8'],
    '4a081f9e3a60a0e580cad484d66fbf5a1505ad313280e96728729069f87f856e' => ['12.8.0-ce.0', '12.8.0-ce.0'],
    '1084266bd81c697b5268b47c76565aa86b821126a6b9fe6ea7b50f64971fc96f' => ['12.8.0-ee', '12.8.2-ee'],
    '7310c45f08c5414036292b0c4026f281a73cf8a01af82a81257dd343f378bbb5' => ['12.8.5-ee', '12.8.10-ee'],
    '45b2cf643afd34888294a073bf55717ea00860d6a1dca3d301ded1d0040cac44' => ['12.9', '12.9'],
    '473ef436c59830298a2424616d002865f17bb5a6e0334d3627affa352a4fc117' => ['12.9.0-ee', '12.9.10-ee'],
    'c8d8d30d89b00098edab024579a3f3c0df2613a29ebcd57cdb9a9062675558e4' => ['13.0', '13.0'],
    'ae0edd232df6f579e19ea52115d35977f8bdbfa9958e0aef2221d62f3a39e7d8' => ['13.0.0-ee', '13.0.14-ee'],
    '4abc4e078df94075056919bd59aed6e7a0f95067039a8339b8f614924d8cb160' => ['13.1', '13.1'],
    '02aa9533ec4957bb01d206d6eaa51d762c7b7396362f0f7a3b5fb4dd6088745b' => ['13.10.0', '13.10.5'],
    '27d2c4c4e2fcf6e589e3e1fe85723537333b087003aa4c1d2abcf74d5c899959' => ['13.10.3-ee', '13.10.5-ee'],
    'ec9dfedd7bd44754668b208858a31b83489d5474f7606294f6cc0128bb218c6d' => ['13.1.0-ce.0', '13.1.0-ce.0'],
    'bf1c397958ee5114e8f1dadc98fa9c9d7ddb031a4c3c030fa00c315384456218' => ['13.1.0-ee', '13.1.0-ee'],
    'a573aed3df818ca78ab40c01ae3514e16271a18e3c83122deab5d5623b25d4fe' => ['13.11.0', '13.11.7'],
    'e355f614211d036d0b3ffac4cd76da00d89e05717df61629e82571e20ac27488' => ['13.11.0-ee', '13.11.7-ee'],
    'c923fa3e71e104d50615978c1ab9fcfccfcbada9e8df638fc27bf4d4eb72d78c' => ['13.1.1-ee', '13.1.11-ee'],
    'a624c11e908db556820e9b07de96e0a465e9be5d5e6b68cdafe6d5c95c99798b' => ['13.12.0-ee', '13.12.15-ee'],
    'a9308f85e95b00007892d451fd9f6beabcd8792b4c5f8cd7524ba7e941d479c9' => ['13.2', '13.2'],
    'f154ef27cf0f1383ba4ca59531058312b44c84d40938bc8758827023db472812' => ['13.2.0-ce.0', '13.2.0-ce.0'],
    '655ad8aea57bdaaad10ff208c7f7aa88c9af89a834c0041ffc18c928cc3eab1f' => ['13.2.0-ee', '13.2.0-ee'],
    '81c5f2c7b2c0b0abaeb59585f36904031c21b1702c24349404df52834fbd7ad3' => ['13.2.1-ee', '13.2.10-ee'],
    '455d114267e5992b858fb725de1c1ddb83862890fe54436ffea5ff2d2f72edc8' => ['13.3', '13.3'],
    '30a9dffe86b597151eff49443097496f0d1014bb6695a2f69a7c97dc1c27828f' => ['13.3.0-ee', '13.3.7-ee'],
    '7f1c7b2bfaa6152740d453804e7aa380077636cad101005ed85e70990ec20ec5' => ['13.3.8-ce.0', '13.3.8-ce.0'],
    'b50bfeb87fe7bb245b31a0423ccfd866ca974bc5943e568ce47efb4cd221d711' => ['13.3.8-ee', '13.3.9-ee'],
    '969119f639d0837f445a10ced20d3a82d2ea69d682a4e74f39a48a4e7b443d5e' => ['13.4', '13.4'],
    'f9ab217549b223c55fa310f2007a8f5685f9596c579f5c5526e7dcb204ba0e11' => ['13.4.0-ce.0', '13.4.0-ce.0'],
    'ac9b38e86b6c87bf8db038ae23da3a5f17a6c391b3a54ad1e727136141a7d4f5' => ['13.4.0-ee', '13.4.0-ee'],
    'e2578590390a9eb10cd65d130e36503fccb40b3921c65c160bb06943b2e3751a' => ['13.4.1-ee', '13.4.7-ee'],
    'bf1ba5d5d3395adc5bad6f17cc3cb21b3fb29d3e3471a5b260e0bc5ec7a57bc4' => ['13.5.0-ce.0', '13.5.0-ce.0'],
    '015d088713b23c749d8be0118caeb21039491d9812c75c913f48d53559ab09df' => ['13.5.0-ee', '13.5.3-ee'],
    '0993beabc8d2bb9e3b8d12d24989426b909921e20e9c6a704de7a5f1dfa93c59' => ['13.5.4-ee', '13.5.7-ee'],
    'be9a23d3021354ec649bc823b23eab01ed235a4eb730fd2f4f7cdb2a6dee453a' => ['13.5.6', '13.5.7'],
    '051048a171ccf14f73419f46d3bd8204aa3ed585a72924faea0192f53d42cfce' => ['13.6.0', '13.6.7'],
    '62e4cc014d9d96f9cbf443186289ffd9c41bdfe951565324891dcf38bcca5a51' => ['13.6.0-ee', '13.6.7-ee'],
    'a0c92bafde7d93e87af3bc2797125cba613018240a9f5305ff949be8a1b16528' => ['13.7.0', '13.7.0'],
    '08858ced0ff83694fb12cf155f6d6bf450dcaae7192ea3de8383966993724290' => ['13.7.0-ee', '13.7.7-ee'],
    '79837fd1939f90d58cc5a842a81120e8cecbc03484362e88081ebf3b7e3830e9' => ['13.7.0-rc3.ce.0', '13.7.0-rc3.ce.0'],
    'd0850f616c5b4f09a7ff319701bce0460ffc17ca0349ad2cf7808b868688cf71' => ['13.7.0-rc3.ee', '13.7.0-rc3.ee'],
    '52560ba2603619d2ff1447002a60dcb62c7c957451fb820f1894e1ce7c23821c' => ['13.8.0', '13.8.8'],
    '4990bb27037f3d5f1bffc0625162173ad8043166a1ae5c8505aabe6384935ce2' => ['13.8.0-ee', '13.8.8-ee'],
    'd161b6e25db66456f8e0603de5132d1ff90f9388d0a0305d2d073a67fd229ddb' => ['13.9.0', '13.9.7'],
    '6ae610d783ba9a520b82263f49d2907a52090fecb3ac37819cea12b67e6d94fb' => ['13.9.6-ee', '13.9.7-ee'],
    '90abf7746df5cb82bca9949de6f512de7cb10bec97d3f5103299a9ce38d5b159' => ['14.0.0', '14.0.12'],
    '515dc29796a763b500d37ec0c765957a136c9e1f1972bb52c3d7edcf4b6b8bbe' => ['14.0.0-ee', '14.0.12-ee'],
    '739a920f5840de93f944ec86c5a181d0205f1d9e679a4df1b9bf5b0882ab848a' => ['14.10.0', '14.10.5'],
    '6a58066d1bde4b6e661fbd5bde83d2dd90615ab409b8c8c36e04954fbd923424' => ['14.10.0-ee', '14.10.5-ee'],
    '5cd37ee959b5338b5fb48eafc6c7290ca1fa60e653292304102cc19a16cc25e4' => ['14.1.0', '14.1.8'],
    'c91127b2698c0a2ae0103be3accffe01995b8531bf1027ae4f0a8ad099e7a209' => ['14.1.0-ee', '14.1.8-ee'],
    '4f233d907f30a050ca7e40fbd91742d444d28e50691c51b742714df8181bf4e7' => ['14.2.0', '14.2.5'],
    '383b8952f0627703ada7774dd42f3b901ea2e499fd556fce3ae0c6d604ad72b7' => ['14.2.0-ee', '14.2.5-ee'],
    '57e83f1a3cf7c0fe3cf2357802306688dab60cf6a30d00e14e67826070db92de' => ['14.2.6', '14.2.7'],
    'e539e07c389f60596c92b06467c735073788196fa51331255d66ff7afde5dfee' => ['14.2.6-ee', '14.2.7-ee'],
    'a8bf3d1210afa873d9b9af583e944bdbf5ac7c8a63f6eccc3d6795802bd380d2' => ['14.3.0', '14.3.3'],
    '2ea7e9be931f24ebc2a67091b0f0ff95ba18e386f3d312545bb5caaac6c1a8be' => ['14.3.0-ee', '14.3.3-ee'],
    'ba74062de4171df6109c4c96da1ebe2b538bb6cc7cd55867cbdfba44777700e1' => ['14.3.4', '14.3.6'],
    '5df2cb13ec314995ea43d698e888ddb240dbc7ccb6e635434dc8919eced3e25f' => ['14.3.4-ee', '14.3.6-ee'],
    '50d9206410f00bb00cc8f95865ab291c718e7a026e7fdc1fc9db0480586c4bc9' => ['14.4.0', '14.4.0'],
    'a4333a9de660b9fc4d227403f57d46ec275d6a6349a6f5bda0c9557001f87e5d' => ['14.4.0-ee', '14.4.0-ee'],
    '775f130d36e9eb14cb67c6a63551511b87f78944cebcf6cdddb78292030341df' => ['14.4.1', '14.4.4'],
    'ff058b10a8dce9956247adba2e410a7f80010a236b2269fb53e0df5cd091e61d' => ['14.4.1-ee', '14.4.5-ee'],
    '1832611738f1e31dd00a8293bbf90fce9811b3eea5b21798a63890dbc51769c8' => ['14.5.0', '14.5.4'],
    '1d765038b21c5c76ff8492561c29984f3fa5c4b8cfb3a6c7b216ac8ab18b78c7' => ['14.5.0-ee', '14.5.4-ee'],
    '8b78708916f28aa9e54dacf9c9c08d720837ce78d8260c36c0f828612567d353' => ['14.6.0', '14.6.7'],
    '301b60d2c71a595adfb65b22edee9023961c5190e1807f6db7c597675b0a61f0' => ['14.6.0-ee', '14.6.7-ee'],
    'cfa6748598b5e507db0e53906a7639e2c197a53cb57da58b0a20ed087cc0b9d5' => ['14.7.0', '14.7.7'],
    '6fa9fec63ba24ec06fcae0ec30d1369619c2c3323fe9ddc4849af86457d59eef' => ['14.7.0-ee', '14.7.7-ee'],
    '1d840f0c4634c8813d3056f26cbab7a685d544050360a611a9df0b42371f4d98' => ['14.8.0', '14.8.6'],
    'f8ba2470fbf1e30f2ce64d34705b8e6615ac964ea84163c8a6adaaf8a91f9eac' => ['14.8.0-ee', '14.8.6-ee'],
    '003236d7e2c5f1f035dc8b67026d7583ee198b568932acd8faeac18cec673dfa' => ['14.9.0', '14.9.5'],
    '6eb5eaa5726150b8135a4fd09118cfd6b29f128586b7fa5019a04f1c740e9193' => ['14.9.0-ee', '14.9.5-ee'],
    '1062bbba2e9b04e360569154a8df8705a75d9e17de1a3a9acd5bd20f000fec8b' => ['15.0.0', '15.0.5'],
    '1ae98447c220181b7bd2dfe88018cb6e1b1e4d12d7b8c224d651a48ed2d95dfe' => ['15.0.0-ee', '15.0.1-ee'],
    'a6d68fb0380bece011b0180b2926142630414c1d7a3e268fb461c51523b63778' => ['15.0.2-ee', '15.0.5-ee'],
    '971982e3e67f5419507bf8034fc7ae9754f607a4f0e6a7483cd7d579936d0a43' => ['15.10.0', '15.10.8'],
    'e7b1efce983de69e755cecf958ad52fe9c578fee502ec2046fbe4d418e12c237' => ['15.10.0-ee', '15.10.8-ee'],
    '7d0792b17e1d2ccac7c6820dda1b54020b294006d7867b7d78a05060220a0213' => ['15.1.0', '15.1.6'],
    '95ae8966ec1e6021f2553c7d275217fcfecd5a7f0b206151c5fb701beb7baf1e' => ['15.1.0-ee', '15.1.6-ee'],
    'ba1723ee38768ca6dcce3e345b1f4cef7372520f2adbb0b5be32a0e6a2b6d5df' => ['15.11.0', '15.11.13'],
    'a727ffdf1055442288d2fbc8b2ab23c38185697594725ea899f9faa653fad748' => ['15.11.0-ee', '15.11.13-ee'],
    'f74c42d987ff17ae7218016d2e49fa99c55467959a0616084a7227c53a8b702d' => ['15.2.0', '15.2.5'],
    '1e3d7f89df5b5446401d669796adf858c6742cb23a3d41b53f51a3c312c798cc' => ['15.2.0-ee', '15.2.5-ee'],
    '8dcb2fd4b99a99a1c96d54c852feb9a10d712cdd32aec422cfdf03b4ee83e371' => ['15.3.0', '15.3.2'],
    '1caf2b894e48f649fcfd6b20de756e07ce64c1a756b9a20ff4505caeffa1a361' => ['15.3.0-ee', '15.3.2-ee'],
    '6cbb01bf749e401b7f580040ef7df64328f65f40292b6df5b3384909f1b6bd88' => ['15.3.3', '15.3.5'],
    '5a73588c1bf39ca7421dff5d8a03b887f0ebcb4897d6c136dfe03fa63a11b1ad' => ['15.3.3-ee', '15.3.5-ee'],
    '4bf4ff2b0d769377b107e2683ec22b5acaf2e63a5bfc4cbe66edd81b6ba0eb4f' => ['15.4.0', '15.4.6'],
    '0ac028d3833c573c3e7cd054219213d6b36474cb4531a251238d9fa25831d97a' => ['15.4.0-ee', '15.4.6-ee'],
    'b1bf30dd8b5a69c9d3a8daa3c88da77db3707a1e61063616e599f10b3a23547e' => ['15.5.0', '15.5.9'],
    'badd1d1762b624e5c7d251e045a3b2a3693054edbcb0115eb3cc64758fa62e92' => ['15.5.0-ee', '15.5.9-ee'],
    '67bc0612f9d717c9132e562be68773069c94a2dd9f952b1622c47ab0cb0438b4' => ['15.6.0', '16.6.7'],
    '7ac3b54e2ee2a129462d6702c9857a04f1a405f7254b89a2b3dfc7e73e80a489' => ['15.6.0-ee', '15.6.8-ee'],
    '1e8c169a1e3fd710539d4a64b60f69b9d1bca3ec4b8272d22f36b158ffc276fe' => ['15.7.0', '15.7.9'],
    'dac7d8befc64f632fac344ebdca56066e013a4e260c3bdfb375fcf6dd30c3c56' => ['15.7.0-ee', '14.7.9-ee'],
    'abd1002d017cf458a22594e9eebc44f159b87466d62ff38da0a4364e1c486007' => ['15.8.0', '15.8.6'],
    'f6b592d2e7570ce5d28f3dbf7170c0b3aa19dcb951f8c9e9ebe6cd5ec44691e8' => ['15.8.0-ee', '15.8.6-ee'],
    'c2e2e19b4ed75b3c7745158c2cccd4f82baa0ea853cd1688965c0e6865aa4fe3' => ['15.9.0', '15.9.8'],
    'c19a43b56f2b869d14e8b8865f2673e99e95a3f9912c95776e2aa44d0de56416' => ['15.9.0-ee', '15.9.8-ee'],
    '77ee44de16d2f31b4ddfd214b60b6327fe48b92df7054b1fb928fd6d4439fc7e' => ['16.0.0', '16.0.8'],
    'fb3d9b8e0a1937690eb35bd8b7a8686b51f36226bc9c29f0ea1621d568030c1a' => ['16.0.0-ee', '16.0.8-ee'],
    'bada36d178d3db075d85c6e2bf2a094b8519c2551d4569a2c2cb8b5b2b07247c' => ['16.1.0', '16.1.6'],
    'ad779fabb121ac9d0c594b996d2fddb1fee9ce36c886c73c3d0e6fe10233819b' => ['16.1.0-ee', '16.1.6-ee'],
    '7dc3e992d5cc9567299c4981b2de6be6a12ae7c78bb9535d5485b0239c3b3f14' => ['16.2.0', '16.2.7'],
    '106174ae025caa47e54ebda6fb32a305a86857c1a808ab1a76a697e8a286166c' => ['16.2.0-ee', '16.2.7-ee'],
    'dee053ee9a9f14f8790cb0ac27bfaf6279e364d5219b9637f1c05049e1da038e' => ['16.2.8', '16.2.9'],
    '198963a1fcb2babf24b04c7c3a57fe439f453a90e1820ef7228d23a420b137ec' => ['16.2.8-ee', '16.2.9-ee'],
    'b35365c3f2d60a068185eacd7e836e1f173c0c4eb3af308fd388f1b84db673b4' => ['16.3.0', '16.3.4'],
    '6687cea99d08705f41c22ba6c0f625668940d80a47e99488bf0d3d4bafa9d398' => ['16.3.0-ee', '16.3.4-ee'],
    '8ebfa16265f86eb24ceda740b31d44d2e5d86ceb9fba74eb308f08e1f99ccaa8' => ['16.3.5', '16.3.7'],
    '1d30846db8d63a25cb7d1a54a8ef11af9382c4d5e95fcc6ba7c8f34f9581d51d' => ['16.3.5-ee', '16.3.7-ee'],
    'cfc4d03e10ba8e1d144a4508f036f477fa5281690eca7258d5ef069d98614b41' => ['16.4.0', '16.4.0'],
    'c10b409df4222d166bfe9b34b787e05a671f9116b47ee10265029bfda6c5305b' => ['16.4.0-ee', '16.4.0-ee'],
    'e803bb812a5c601a017cbfaa6d442b51c869a084d04a0e2b77dfee19959bc000' => ['16.4.1', '16.4.5'],
    'f79ed5a6b0dfecf39281aeefcdd5b15d7cc6d871a3ae20e60c40d6a718377704' => ['16.4.1-ee', '16.4.5-ee'],
    'deeef002fddf6f74357454676107b4ec50cf51f70394f2368f404683f1884132' => ['16.5.0', '16.5.7'],
    '7649badc780fc4e44c1b7063c6153b3c216a5f6f0d7907eed714fac2a39ede73' => ['16.5.0-ee', '16.5.8-ee'],
    '45a1c5dcac6ab55c1b924c47992ed649a5ac98e55dfc62e0d65b178128020aca' => ['16.6.0', '16.6.5'],
    '47ec6054e1998d4cb2623b09faa02993de5f7cc92d34ba60dad2646b3b92a83e' => ['16.6.0-ee', '16.6.7-ee'],
    '8e1fac7546e10d24ab7482b66e2863732a6795cce85e9ff10d8bfd59cad1cd9f' => ['16.7.0', '16.7.3'],
    'e357f1b1a6812a8e72a4aec06b3761062a281129d621bf2e580806a8fca6302d' => ['16.7.0-ee', '16.7.6-ee'],
    '9412070de1081bd15748e4c0278a95f4b9b50ad910d97e8004582321e45a8858' => ['16.8.0', '16.8.0'],
    'aecafb937628c9745dc285b2cb2c41d8a57846c934c2168b0cfec35b3d44e51f' => ['16.8.0-ee', '16.8.3-ee'],
    '73616daa0479bf77369c603146e745cc4cb9874b3b38f81fb2993818049dbf1a' => ['16.9.0-ee', '16.9.1-ee'],
    'a93c372aa48b3b7d546cd010e22fdfe448dbc04e099677c6e90789487ca60f7a' => ['16.9.0-pre', '16.9.0-pre'],
    '9723ad2290324a6ed951c5d4b011743f27afa0b6450cb147a63587b67b70985a' => ['16.9.1', '16.9.1'],
   }.freeze

  include Msf::Exploit::Remote::HTTP::Gitlab::Rest::V4::Version

  # Parses the Gitlab version information and ensures an array of two Rex::Version objects are returned in the
  # following format: [Rex::Version(low_version), Rex::Version(high_version)] even if low_version and high_version
  # are the same.
  #
  # @return [[Rex::Version(low_version), Rex::Version(high_version)],nil] Gitlab version range if found, nil otherwise
  def convert_to_rex_version_range(version)
    return nil unless version

    if version.is_a?(Array) && version.length == 2
      low_version, high_version = version
      low_version = Rex::Version.new(low_version)
      high_version = Rex::Version.new(high_version)
      [low_version, high_version]
    else
      version = Rex::Version.new(version)
      [version, version]
    end
  end

  # Extracts the Gitlab version information and returns a version range.
  #
  # @return [[Rex::Version(low_version), Rex::Version(high_version)],nil] Gitlab version if found, nil otherwise
  def gitlab_version
    version = gitlab_version_css(normalize_uri(target_uri.path))
    return convert_to_rex_version_range(version) if version

    version = gitlab_version_rest
    return convert_to_rex_version_range(version) if version

    version = gitlab_version_help_commit(normalize_uri(target_uri.path))
    return convert_to_rex_version_range(version) if version

    nil
  end

  # Checks the name of a CSS file to fingerprint the version
  #
  # @param [String] url, the url of the Gitlab instance
  #
  # @return [String,nil] Gitlab version if found, nil otherwise
  def gitlab_version_css(url)
    res = send_request_cgi!(
      'method' => 'GET',
      'uri' => url
    )
    unless res
      return nil
    end

    match = res.body.match(GITLAB_CSS_PATTERN)
    unless match
      return nil
    end

    version =  GITLAB_CSS_MAP.fetch(match[1], nil)
   if version
     GITLAB_CSS_MAP.fetch(match[1], nil)
   else
     print_warning("The GITLAB_CSS_PATTERN was found in the response body but the hash found: #{match[1]} does not have a corresponding version in the GITLAB_CSS_MAP")
     nil
   end
  end

  # Get the commit hash via the `gon.revision` javascript variable
  #
  # @param [String] url, the url of the Gitlab instance
  #
  # @return [String,nil] Gitlab commit hash if found, nil otherwise
  def gitlab_version_help_commit(url)
    res = send_request_cgi!(
      'method' => 'GET',
      'uri' => normalize_uri(url, '/help')
    )
    unless res
      return nil
    end

    match = res.body.match(';gon[.]revision="([0-9a-f]+)";')
    unless match
      return nil
    end
    return match[1]
  end
end
