/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetMemoryAction
extends BaseRestHandler {
    private static final String ML_GET_MEMORY_ACTION = "ml_get_memory_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetMemoryAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_MEMORY_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/{memory_id}", new Object[0])));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLGetMemoryRequest mlMemoryGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLGetMemoryAction.INSTANCE, (ActionRequest)mlMemoryGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLGetMemoryRequest getRequest(RestRequest request) throws IOException {
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        String memoryTypeStr = RestActionUtils.getParameterId(request, "memory_type");
        MemoryType memoryType = MemoryType.fromString((String)memoryTypeStr);
        String memoryId = RestActionUtils.getParameterId(request, "memory_id");
        return new MLGetMemoryRequest(memoryContainerId, memoryType, memoryId);
    }
}

