/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class XmlTextManipulator
extends AbstractElementManipulator<XmlText> {
    public XmlText handleContentChange(@NotNull XmlText text, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newValue;
        if (text == null) {
            XmlTextManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            XmlTextManipulator.$$$reportNull$$$0(1);
        }
        String value = text.getValue();
        if (range.equals((Object)this.getRangeInElement(text))) {
            newValue = newContent;
        } else {
            StringBuilder replacement = new StringBuilder(value);
            replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
            newValue = replacement.toString();
        }
        if (Objects.equals(value, newValue)) {
            return text;
        }
        if (!newValue.isEmpty()) {
            text.setValue(newValue);
        } else {
            text.deleteChildRange(text.getFirstChild(), text.getLastChild());
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlText text) {
        if (text == null) {
            XmlTextManipulator.$$$reportNull$$$0(2);
        }
        TextRange textRange = XmlTextManipulator.getValueRange(text);
        if (textRange == null) {
            XmlTextManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        String value = xmlText.getValue();
        int i = value.indexOf(value);
        int start = xmlText.displayToPhysical(i);
        return value.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i + value.length() - 1) + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

