/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OutputHandler
extends DefaultHandler {
    private final ErrorHandler eh;
    private int lineNumber = -1;
    private String systemId = null;
    private final StringBuffer message = new StringBuffer();
    private boolean inMessage = false;
    private final String lineSeparator;
    private static final String indent = "  ";
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$schematron$OutputHandler == null ? (class$com$thaiopensource$validate$schematron$OutputHandler = OutputHandler.class$("com.thaiopensource.validate.schematron.OutputHandler")) : class$com$thaiopensource$validate$schematron$OutputHandler);
    static /* synthetic */ Class class$com$thaiopensource$validate$schematron$OutputHandler;

    OutputHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inMessage) {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.message.length() != 0 && this.message.charAt(this.message.length() - 1) == ' ') break;
                        this.message.append(' ');
                        break;
                    }
                    default: {
                        this.message.append(c);
                    }
                }
                ++n3;
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("failed-assertion") || string2.equals("report")) {
            String string4 = attributes.getValue("", "line-number");
            if (string4 == null) {
                this.lineNumber = -1;
            } else {
                try {
                    this.lineNumber = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.lineNumber = -1;
                }
            }
            string4 = attributes.getValue("", "system-id");
            if (string4 != null && string4.equals("")) {
                string4 = null;
            }
            this.systemId = string4;
            this.message.append(this.localizer.message(string2.equals("failed-assertion") ? "failed_assertion" : "report"));
        } else if (string2.equals("statement") || string2.equals("diagnostic")) {
            this.inMessage = true;
            this.message.append(this.lineSeparator);
            this.message.append(indent);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("statement") || string2.equals("diagnostic")) {
            if (this.message.length() > 0 && this.message.charAt(this.message.length() - 1) == ' ') {
                this.message.setLength(this.message.length() - 1);
            }
            this.inMessage = false;
        } else if (string2.equals("failed-assertion") || string2.equals("report")) {
            this.eh.error(new SAXParseException(this.message.toString(), null, this.systemId, this.lineNumber, -1));
            this.message.setLength(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

