/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.installer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.python.community.impl.installer.DownloadableBinaryInstaller;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.impl.PySdkBundle;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.CancelledProcessException;
import com.jetbrains.python.sdk.installer.ExecutionProcessException;
import com.jetbrains.python.sdk.installer.NonZeroExitCodeProcessException;
import com.jetbrains.python.sdk.installer.ProcessException;
import com.jetbrains.python.sdk.installer.TimeoutProcessException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J$\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller;", "Lcom/intellij/python/community/impl/installer/DownloadableBinaryInstaller;", "resourceType", "Lcom/jetbrains/python/sdk/ResourceType;", "<init>", "(Lcom/jetbrains/python/sdk/ResourceType;)V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "process", "", "resourcePaths", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processResource", "canInstall", "", "binary", "Lcom/jetbrains/python/sdk/Binary;", "getResourcesToDownload", "", "intellij.python.community.impl.installer"})
@SourceDebugExtension(value={"SMAP\nResourceTypeBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceTypeBinaryInstaller.kt\ncom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n216#2,2:68\n1#3:70\n1761#4,3:71\n774#4:74\n865#4,2:75\n*S KotlinDebug\n*F\n+ 1 ResourceTypeBinaryInstaller.kt\ncom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller\n*L\n23#1:68,2\n58#1:71,3\n65#1:74\n65#1:75,2\n*E\n"})
public abstract class ResourceTypeBinaryInstaller
extends DownloadableBinaryInstaller {
    @NotNull
    private final ResourceType resourceType;

    public ResourceTypeBinaryInstaller(@NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        this.resourceType = resourceType;
    }

    @NotNull
    public abstract GeneralCommandLine buildCommandLine(@NotNull Resource var1, @NotNull Path var2);

    @Override
    public void process(@NotNull Map<Resource, ? extends Path> resourcePaths, @NotNull ProgressIndicator indicator) throws ProcessException {
        Intrinsics.checkNotNullParameter(resourcePaths, (String)"resourcePaths");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Map<Resource, ? extends Path> $this$forEach$iv = resourcePaths;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Resource, ? extends Path>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Resource, ? extends Path> element$iv;
            Map.Entry<Resource, ? extends Path> entry = element$iv = iterator.next();
            boolean bl = false;
            Resource resource = entry.getKey();
            Path path = entry.getValue();
            this.processResource(resource, path, indicator);
        }
    }

    private final void processResource(Resource resource, Path path, ProgressIndicator indicator) throws ProcessException {
        Comparable<Boolean> comparable;
        indicator.setIndeterminate(true);
        Object[] objectArray = new Object[]{resource.getFileName()};
        indicator.setText(PySdkBundle.message((String)"python.sdk.running.progress.text", (Object[])objectArray));
        indicator.setText2(PySdkBundle.message((String)"python.sdk.running.one.minute.progress.details", (Object[])new Object[0]));
        GeneralCommandLine commandLine = this.buildCommandLine(resource, path);
        BinaryInstallerKt.getLOGGER().info("Running " + commandLine.getCommandLineString());
        ProcessOutput processOutput = null;
        try {
            indicator.checkCanceled();
            ProcessOutput processOutput2 = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(indicator);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
            processOutput = processOutput2;
        }
        catch (Exception e) {
            throw new ExecutionProcessException(commandLine, e);
        }
        Comparable<Boolean> comparable2 = processOutput.isCancelled();
        boolean bl = (Boolean)comparable2;
        boolean bl2 = false;
        Comparable<Boolean> comparable3 = comparable = bl ? comparable2 : null;
        if (comparable != null) {
            boolean bl3 = (Boolean)comparable;
            boolean bl22 = false;
            throw new CancelledProcessException(commandLine, processOutput);
        }
        comparable2 = processOutput.getExitCode();
        int n = ((Number)((Object)comparable2)).intValue();
        boolean bl3 = false;
        Comparable<Boolean> comparable4 = comparable = n != 0 ? comparable2 : null;
        if (comparable != null) {
            int n2 = ((Number)((Object)comparable)).intValue();
            boolean bl4 = false;
            String string = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)"User cancelled", (boolean)true)) {
                throw new CancelledProcessException(commandLine, processOutput);
            }
            throw new NonZeroExitCodeProcessException(commandLine, processOutput);
        }
        comparable2 = processOutput.isTimeout();
        boolean bl4 = (Boolean)comparable2;
        boolean bl5 = false;
        Comparable<Boolean> comparable5 = comparable = bl4 ? comparable2 : null;
        if (comparable != null) {
            boolean bl6 = (Boolean)comparable;
            boolean bl62 = false;
            throw new TimeoutProcessException(commandLine, processOutput);
        }
    }

    @Override
    public boolean canInstall(@NotNull Binary binary) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
            Iterable $this$any$iv = binary.getResources();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resource r = (Resource)element$iv;
                    boolean bl2 = false;
                    if (!(r.getType() == this.resourceType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Resource> getResourcesToDownload(@NotNull Binary binary) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Iterable $this$filter$iv = binary.getResources();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Resource it = (Resource)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == this.resourceType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

