/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyTypeAliasRedeclarationInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyTypeAliasRedeclarationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/inspections/PyTypeAliasRedeclarationInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyTypeAliasStatement", "", "node", "Lcom/jetbrains/python/psi/PyTypeAliasStatement;", "reportRedeclaration", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyTypeAliasRedeclarationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTypeAliasRedeclarationInspection.kt\ncom/jetbrains/python/inspections/PyTypeAliasRedeclarationInspection$Visitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2,2:97\n*S KotlinDebug\n*F\n+ 1 PyTypeAliasRedeclarationInspection.kt\ncom/jetbrains/python/inspections/PyTypeAliasRedeclarationInspection$Visitor\n*L\n92#1:97,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyTypeAliasStatement(@NotNull PyTypeAliasStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.reportRedeclaration((PsiNameIdentifierOwner)node);
        }

        public final void reportRedeclaration(@NotNull PsiNameIdentifierOwner element) {
            PsiElement identifier;
            PsiElement psiElement;
            ScopeOwner owner;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String name = element.getName();
            Ref.ObjectRef writeElement = new Ref.ObjectRef();
            if (name != null && (owner = ScopeUtil.getScopeOwner((PsiElement)element)) != null) {
                Instruction[] instructionArray = ControlFlowCache.getControlFlow(owner).getInstructions();
                Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"getInstructions(...)");
                Instruction[] instructions = instructionArray;
                int startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)((PsiElement)element));
                if (startInstruction >= 0) {
                    ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, arg_0 -> Visitor.reportRedeclaration$lambda$1(arg_0 -> Visitor.reportRedeclaration$lambda$0(startInstruction, name, element, writeElement, arg_0), arg_0));
                }
            }
            if (writeElement.element == null) {
                return;
            }
            List quickFixes = new ArrayList();
            LocalQuickFix quickFix = PythonUiService.getInstance().createPyRenameElementQuickFix((PsiElement)element);
            if (quickFix != null) {
                quickFixes.add(quickFix);
            }
            if ((psiElement = (identifier = element.getNameIdentifier())) == null) {
                psiElement = (PsiElement)element;
            }
            Object[] objectArray = new Object[]{name};
            String string = PyPsiBundle.message("INSP.redeclared.type.alias", objectArray);
            Collection $this$toTypedArray$iv = quickFixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            this.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }

        private static final ControlFlowUtil.Operation reportRedeclaration$lambda$0(int $startInstruction, String $name, PsiNameIdentifierOwner $element, Ref.ObjectRef $writeElement, Instruction instruction) {
            PsiElement originalElement;
            if (instruction instanceof ReadWriteInstruction && ((ReadWriteInstruction)instruction).num() != $startInstruction && Intrinsics.areEqual((Object)$name, (Object)((ReadWriteInstruction)instruction).getName()) && (originalElement = ((ReadWriteInstruction)instruction).getElement()) != null && ((ReadWriteInstruction)instruction).getAccess().isWriteAccess() && originalElement != $element) {
                $writeElement.element = originalElement;
                return ControlFlowUtil.Operation.BREAK;
            }
            return ControlFlowUtil.Operation.NEXT;
        }

        private static final ControlFlowUtil.Operation reportRedeclaration$lambda$1(Function1 $tmp0, Object p0) {
            return (ControlFlowUtil.Operation)$tmp0.invoke(p0);
        }
    }
}

