\name{ErodeObjectMorphologyImageFilter}
\alias{ErodeObjectMorphologyImageFilter}
\title{ErodeObjectMorphologyImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Erosion of an object in an image.
ErodeObjectMorphologyImageFilter}
\details{
Erosion of an image using binary morphology. Pixel values matching the
object value are considered the "object" and all other pixels are
"background". This is useful in processing mask images containing
only one object.
If the pixel covered by the center of the kernel has the pixel value
ObjectValue and the pixel is adjacent to a non-object valued pixel,
then the kernel is centered on the object-value pixel and neighboring
pixels covered by the kernel are assigned the background value. The
structuring element is assumed to be composed of binary values (zero
or one).
See:
ObjectMorphologyImageFilter , BinaryFunctionErodeImageFilter
BinaryErodeImageFilter
ErodeObjectMorphology for the procedural interface
itk::ErodeObjectMorphologyImageFilter for the Doxygen on the original ITK class.
ErodeObjectMorphologyImageFilter}
%C++ includes: sitkErodeObjectMorphologyImageFilter.h
\section{Methods}{
\describe{
\item{ ErodeObjectMorphologyImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Get the value to be assigned to eroded pixels
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetObjectValue() const:}{}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value to be assigned to eroded pixels
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetObjectValue(double ObjectValue):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ErodeObjectMorphologyImageFilter():}{
Destructor
}
}
}
