/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVWriter;
import com.oracle.graal.python.builtins.modules.csv.CSVWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyNumberCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CSVWriter})
public final class CSVWriterBuiltins
extends PythonBuiltins {
    private static final String WRITEROW_DOC = "writerow(iterable)\n\nConstruct and write a CSV record from an iterable of fields.  Non-string\nelements will be converted to string.";
    private static final String WRITEROWS_DOC = "writerows(iterable of iterables)\n\nConstruct and write a series of iterables to a csv file.  Non-string\nelements will be converted to string.";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="dialect", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetDialectNode
    extends PythonUnaryBuiltinNode {
        GetDialectNode() {
        }

        @Specialization
        static CSVDialect doIt(CSVWriter self) {
            return self.dialect;
        }
    }

    @Builtin(name="writerows", parameterNames={"$self", "seqseq"}, minNumOfPositionalArgs=2, doc="writerows(iterable of iterables)\n\nConstruct and write a series of iterables to a csv file.  Non-string\nelements will be converted to string.")
    @GenerateNodeFactory
    public static abstract class WriteRowsNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object doIt(VirtualFrame frame, CSVWriter self, Object seq, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached WriteRowNode writeRow) {
            Object iter = getIter.execute((Frame)frame, inliningTarget, seq);
            while (true) {
                Object row;
                try {
                    row = nextNode.execute((Frame)frame, inliningTarget, iter);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                writeRow.execute(frame, self, row);
            }
            return PNone.NONE;
        }
    }

    @GenerateInline(value=false)
    protected static abstract class JoinAppendData
    extends Node {
        protected JoinAppendData() {
        }

        abstract boolean execute(Node var1, TruffleStringBuilder var2, CSVDialect var3, TruffleString var4, boolean var5, boolean var6, PRaiseNode var7, TruffleStringBuilder.AppendStringNode var8);

        @Specialization
        static boolean joinAppendData(Node inliningTarget, TruffleStringBuilder sb, CSVDialect dialect, TruffleString field, boolean quotedArg, boolean isCopyPhase, PRaiseNode raiseNode, TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
            boolean quoted = quotedArg;
            if (isCopyPhase && quoted) {
                JoinAppendData.addChar(sb, dialect.quoteChar, true, appendStringNode);
            }
            if (field != null) {
                TruffleStringIterator tsi = createCodePointIteratorNode.execute((AbstractTruffleString)field, PythonUtils.TS_ENCODING);
                while (tsi.hasNext()) {
                    boolean wantEscape = false;
                    int c = nextNode.execute(tsi, PythonUtils.TS_ENCODING);
                    if (JoinAppendData.needsEscape(dialect, c, byteIndexOfCodePointNode)) {
                        if (dialect.quoting == QuoteStyle.QUOTE_NONE) {
                            wantEscape = true;
                        } else {
                            if (c == dialect.quoteCharCodePoint) {
                                if (dialect.doubleQuote) {
                                    JoinAppendData.addChar(sb, dialect.quoteChar, isCopyPhase, appendStringNode);
                                } else {
                                    wantEscape = true;
                                }
                            } else if (c == dialect.escapeCharCodePoint) {
                                wantEscape = true;
                            }
                            if (!wantEscape) {
                                quoted = true;
                            }
                        }
                        if (wantEscape) {
                            if (dialect.escapeCharCodePoint == -1) {
                                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.ESCAPE_WITHOUT_ESCAPECHAR);
                            }
                            JoinAppendData.addChar(sb, dialect.escapeChar, isCopyPhase, appendStringNode);
                        }
                    }
                    JoinAppendData.addChar(sb, c, isCopyPhase, appendCodePointNode);
                }
            }
            if (quoted) {
                JoinAppendData.addChar(sb, dialect.quoteChar, isCopyPhase, appendStringNode);
            }
            return quoted;
        }

        static void addChar(TruffleStringBuilder sb, TruffleString c, boolean isCopyPhase, TruffleStringBuilder.AppendStringNode appendStringNode) {
            if (isCopyPhase) {
                appendStringNode.execute(sb, (AbstractTruffleString)c);
            }
        }

        static void addChar(TruffleStringBuilder sb, int c, boolean isCopyPhase, TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
            if (isCopyPhase) {
                appendCodePointNode.execute(sb, c, 1, true);
            }
        }

        private static boolean needsEscape(CSVDialect dialect, int c, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
            return c == dialect.delimiterCodePoint || c == dialect.escapeCharCodePoint || c == dialect.quoteCharCodePoint || c == 10 || c == 13 || byteIndexOfCodePointNode.execute((AbstractTruffleString)dialect.lineTerminator, c, 0, dialect.lineTerminator.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0;
        }
    }

    @Builtin(name="writerow", parameterNames={"$self", "seq"}, minNumOfPositionalArgs=2, doc="writerow(iterable)\n\nConstruct and write a CSV record from an iterable of fields.  Non-string\nelements will be converted to string.")
    @GenerateNodeFactory
    public static abstract class WriteRowNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, CSVWriter self, Object seq, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetClassNode getClass, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached CallUnaryMethodNode callNode, @Cached JoinAppendData joinAppendData, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyObjectStrAsTruffleStringNode objectStrAsTruffleStringNode, @Cached PyNumberCheckNode pyNumberCheckNode, @Cached PyIterNextNode nextNode, @Cached PRaiseNode raiseNode) {
            Object iter;
            try {
                iter = getIter.execute((Frame)frame, inliningTarget, seq);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.EXPECTED_ITERABLE_NOT_S, getClass.execute(inliningTarget, seq));
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            CSVDialect dialect = self.dialect;
            boolean first = true;
            boolean nullField = false;
            while (true) {
                Object field;
                try {
                    field = nextNode.execute((Frame)frame, inliningTarget, iter);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                if (!first) {
                    appendStringNode.execute(sb, (AbstractTruffleString)dialect.delimiter);
                } else {
                    first = false;
                }
                boolean quoted = switch (dialect.quoting) {
                    case QuoteStyle.QUOTE_NONNUMERIC -> !pyNumberCheckNode.execute(inliningTarget, field);
                    case QuoteStyle.QUOTE_ALL -> true;
                    case QuoteStyle.QUOTE_STRINGS -> unicodeCheckNode.execute(inliningTarget, field);
                    case QuoteStyle.QUOTE_NOTNULL -> field != PNone.NONE;
                    default -> false;
                };
                boolean bl = nullField = field == PNone.NONE;
                if (nullField) {
                    WriteRowNode.joinAppend(inliningTarget, sb, self, null, quoted, raiseNode, appendStringNode, codePointLengthNode, joinAppendData);
                    continue;
                }
                TruffleString str = objectStrAsTruffleStringNode.execute(null, inliningTarget, field);
                WriteRowNode.joinAppend(inliningTarget, sb, self, str, quoted, raiseNode, appendStringNode, codePointLengthNode, joinAppendData);
            }
            if (!first && sb.isEmpty()) {
                if (dialect.quoting == QuoteStyle.QUOTE_NONE || nullField && (dialect.quoting == QuoteStyle.QUOTE_STRINGS || dialect.quoting == QuoteStyle.QUOTE_NOTNULL)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.EMPTY_FIELD_RECORD_MUST_BE_QUOTED);
                }
                WriteRowNode.joinAppend(inliningTarget, sb, self, null, true, raiseNode, appendStringNode, codePointLengthNode, joinAppendData);
            }
            appendStringNode.execute(sb, (AbstractTruffleString)dialect.lineTerminator);
            return callNode.executeObject((Frame)frame, self.write, toStringNode.execute(sb));
        }

        static void joinAppend(Node inliningTarget, TruffleStringBuilder sb, CSVWriter self, TruffleString field, boolean quotedArg, PRaiseNode raiseNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleString.CodePointLengthNode codePointLengthNode, JoinAppendData joinAppendData) {
            boolean quoted = quotedArg;
            CSVDialect dialect = self.dialect;
            int fieldLen = 0;
            if (field != null) {
                fieldLen = codePointLengthNode.execute((AbstractTruffleString)field, PythonUtils.TS_ENCODING);
            }
            if (fieldLen == 0 && dialect.delimiterCodePoint == 32 && dialect.skipInitialSpace) {
                if (dialect.quoting == QuoteStyle.QUOTE_NONE || field == null && (dialect.quoting == QuoteStyle.QUOTE_STRINGS || dialect.quoting == QuoteStyle.QUOTE_NOTNULL)) {
                    raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.DELIMITER_IS_A_SPACE_AND_SKIPINITIALSPACE_IS_TRUE);
                }
                quoted = true;
            }
            quoted = joinAppendData.execute(inliningTarget, sb, dialect, field, quoted, false, raiseNode, appendStringNode);
            joinAppendData.execute(inliningTarget, sb, dialect, field, quoted, true, raiseNode, appendStringNode);
        }
    }
}

