/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;

public abstract class ArraySerializerBase<T>
extends StdContainerSerializer<T> {
    protected final Boolean _unwrapSingle;

    protected ArraySerializerBase(Class<T> cls) {
        super(cls);
        this._unwrapSingle = null;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src) {
        super((StdContainerSerializer<?>)src);
        this._unwrapSingle = src._unwrapSingle;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property, Boolean unwrapSingle) {
        super(src, property);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract ValueSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public ValueSerializer<?> createContextual(SerializationContext serializers, BeanProperty property) {
        JsonFormat.Value format;
        Boolean unwrapSingle = null;
        if (property != null && (format = this.findFormatOverrides(serializers, property, this.handledType())) != null && !Objects.equals(unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED), this._unwrapSingle)) {
            return this._withResolved(property, unwrapSingle);
        }
        return this;
    }

    @Override
    public final void serializeWithType(T value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        this.serializeContents(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializationContext var3) throws JacksonException;

    protected final boolean _shouldUnwrapSingle(SerializationContext provider) {
        if (this._unwrapSingle == null) {
            return provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        return this._unwrapSingle;
    }
}

