/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.templatemode.TemplateMode;

public final class ExecutionInfo {
    private final ITemplateContext context;
    private final Calendar now;

    public ExecutionInfo(ITemplateContext context) {
        this.context = context;
        this.now = Calendar.getInstance(context.getLocale());
    }

    public String getTemplateName() {
        return this.context.getTemplateData().getTemplate();
    }

    public TemplateMode getTemplateMode() {
        return this.context.getTemplateData().getTemplateMode();
    }

    public String getProcessedTemplateName() {
        return this.context.getTemplateStack().get(0).getTemplate();
    }

    public TemplateMode getProcessedTemplateMode() {
        return this.context.getTemplateStack().get(0).getTemplateMode();
    }

    public List<String> getTemplateNames() {
        List<TemplateData> templateStack = this.context.getTemplateStack();
        ArrayList<String> templateNameStack = new ArrayList<String>(templateStack.size());
        for (TemplateData templateData : templateStack) {
            templateNameStack.add(templateData.getTemplate());
        }
        return templateNameStack;
    }

    public List<TemplateMode> getTemplateModes() {
        List<TemplateData> templateStack = this.context.getTemplateStack();
        ArrayList<TemplateMode> templateModeStack = new ArrayList<TemplateMode>(templateStack.size());
        for (TemplateData templateData : templateStack) {
            templateModeStack.add(templateData.getTemplateMode());
        }
        return templateModeStack;
    }

    public List<TemplateData> getTemplateStack() {
        return this.context.getTemplateStack();
    }

    public Calendar getNow() {
        return this.now;
    }
}

